/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.CombinedExpressionType;
import de.calamanari.adl.irl.CombinedExpression;
import de.calamanari.adl.irl.CoreExpression;
import de.calamanari.adl.irl.MatchExpression;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.irl.SimpleExpression;

public class ExpressionAlias
implements Comparable<ExpressionAlias> {
    private final CoreExpression expression;
    private final String name;
    private int positiveReferenceCount;
    private int negativeReferenceCount;

    public ExpressionAlias(String name, CoreExpression expression) {
        block4: {
            block5: {
                CombinedExpression cmb;
                this.positiveReferenceCount = 0;
                this.negativeReferenceCount = 0;
                if (name == null || name.isBlank() || expression == null) {
                    throw new IllegalArgumentException(String.format("Arguments must not be null, empty or blank, given: name=%s, expression=%s", name, expression));
                }
                if (expression instanceof MatchExpression) break block4;
                if (!(expression instanceof CombinedExpression) || (cmb = (CombinedExpression)expression).combiType() != CombinedExpressionType.OR) break block5;
                if (cmb.members().stream().allMatch(MatchExpression.class::isInstance)) break block4;
            }
            throw new IllegalArgumentException(String.format("Aliases can only be positive match expressions or combined expressions of type OR of positive match expressions, given: name=%s, expression=%s", name, expression));
        }
        this.name = name;
        this.expression = expression;
    }

    public CoreExpression getExpression() {
        return this.expression;
    }

    public String getName() {
        return this.name;
    }

    public int getPositiveReferenceCount() {
        return this.positiveReferenceCount;
    }

    public int getNegativeReferenceCount() {
        return this.negativeReferenceCount;
    }

    public void registerPositiveReference() {
        ++this.positiveReferenceCount;
    }

    public void registerNegativeReference() {
        ++this.negativeReferenceCount;
    }

    public boolean requiresAllRowsOfTableQueryInUnion() {
        MatchExpression match;
        CoreExpression coreExpression;
        return this.positiveReferenceCount > 0 && (this.negativeReferenceCount > 0 || (coreExpression = this.expression) instanceof MatchExpression && (match = (MatchExpression)coreExpression).operator() == MatchOperator.IS_UNKNOWN);
    }

    public boolean isReferenceMatch() {
        SimpleExpression simple;
        CoreExpression coreExpression = this.expression;
        return coreExpression instanceof SimpleExpression && (simple = (SimpleExpression)coreExpression).referencedArgName() != null;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionAlias other = (ExpressionAlias)obj;
        return this.name.equals(other.name);
    }

    @Override
    public int compareTo(ExpressionAlias o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", positiveReferenceCount=" + this.positiveReferenceCount + ", negativeReferenceCount=" + this.negativeReferenceCount + ", expression=" + String.valueOf(this.expression) + "]";
    }
}

