/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.sql.QueryParameter;
import de.calamanari.adl.sql.cnv.ColumnConditionType;
import de.calamanari.adl.sql.config.AdlSqlColumn;
import java.util.List;

public record ColumnCondition(ColumnConditionType type, MatchOperator operator, AdlSqlColumn column, List<QueryParameter> parameters) {
    public ColumnCondition {
        if (operator == null || type == null || column == null || parameters == null || parameters.isEmpty()) {
            throw new IllegalArgumentException(String.format("Arguments must not be null, parameters must not be empty, given: type=%s, operator=%s, column=%s, parameters=%s", new Object[]{type, operator, column, parameters}));
        }
        if ((type == ColumnConditionType.SINGLE || type == ColumnConditionType.FILTER_LEFT || type == ColumnConditionType.FILTER_RIGHT || type == ColumnConditionType.AFTER_TODAY) && parameters.size() > 1) {
            throw new IllegalArgumentException(String.format("When this type is specified, only one parameter can be provided, given: type=%s, operator=%s, column=%s, parameters=%s", new Object[]{type, operator, column, parameters}));
        }
        if (type == ColumnConditionType.IN_CLAUSE && parameters.size() < 2) {
            throw new IllegalArgumentException(String.format("When type INCLAUSE is specified, at least two parameters must be provided, given: type=%s, operator=%s, column=%s, parameters=%s", new Object[]{type, operator, column, parameters}));
        }
        if (type == ColumnConditionType.DATE_RANGE && parameters.size() != 2) {
            throw new IllegalArgumentException(String.format("When type DATE_RANGE is specified, two parameters are expected, the original date and the day after, given: type=%s, operator=%s, column=%s, parameters=%s", new Object[]{type, operator, column, parameters}));
        }
    }
}

