/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql;

import de.calamanari.adl.sql.QueryParameter;
import de.calamanari.adl.sql.QueryPreparationException;
import de.calamanari.adl.sql.QueryTemplateParser;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record QueryTemplateWithParameters(String qmTemplate, List<QueryParameter> orderedParameters, List<Integer> qmPositions) implements Serializable
{
    private static final long serialVersionUID = 418932408030638050L;
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryTemplateWithParameters.class);

    public QueryTemplateWithParameters(String qmTemplate, List<QueryParameter> orderedParameters, List<Integer> qmPositions) {
        if (qmTemplate == null || orderedParameters == null || qmPositions == null || QueryTemplateWithParameters.containsAnyNull(orderedParameters) || QueryTemplateWithParameters.containsAnyNull(qmPositions)) {
            throw new IllegalArgumentException(String.format("Arguments must not be null lists must not contain nulls, given: template=%s, orderedParameters=%s, qmPositions=%s", qmTemplate, orderedParameters, qmPositions));
        }
        if (orderedParameters.size() != qmPositions.size()) {
            throw new IllegalArgumentException(String.format("The number of question mark positions must be equal to the number of parameters: template=%s, orderedParameters=%s, qmPositions=%s", qmTemplate, orderedParameters, qmPositions));
        }
        for (int qmPosition : qmPositions) {
            if (qmPosition < 0 || qmPosition >= qmTemplate.length()) {
                throw new IllegalArgumentException(String.format("Questionmark postion %s out of range: template=%s, orderedParameters=%s, qmPositions=%s", qmPosition, qmTemplate, orderedParameters, qmPositions));
            }
            if (qmTemplate.charAt(qmPosition) == '?') continue;
            throw new IllegalArgumentException(String.format("Questionmark expected at position %s in template: template=%s, orderedParameters=%s, qmPositions=%s", qmPosition, qmTemplate, orderedParameters, qmPositions));
        }
        this.qmTemplate = qmTemplate;
        this.orderedParameters = Collections.unmodifiableList(new ArrayList<QueryParameter>(orderedParameters));
        this.qmPositions = Collections.unmodifiableList(new ArrayList<Integer>(qmPositions));
    }

    public static QueryTemplateWithParameters of(String queryTemplate, List<QueryParameter> parameters) {
        return new Builder(queryTemplate, parameters).get();
    }

    private static boolean containsAnyNull(List<?> values) {
        return values.stream().anyMatch(Objects::isNull);
    }

    public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.qmTemplate());
        this.apply(stmt);
        return stmt;
    }

    public void apply(PreparedStatement stmt) throws SQLException {
        int idx = 1;
        for (QueryParameter parameter : this.orderedParameters) {
            if (parameter.value() == null) {
                LOGGER.warn("Setting a parameter to NULL usually indicates a mistake (write IS [NOT] NULL instead), given: stmt={}, parameterIdx={}, parameter={}", new Object[]{stmt, idx, parameter});
            }
            parameter.adlSqlType().getQueryParameterApplicator().apply(stmt, parameter, idx);
            ++idx;
        }
    }

    public void applyUnsafe(StringBuilder sb) {
        if (this.orderedParameters.isEmpty()) {
            sb.append(this.qmTemplate);
            return;
        }
        int parameterIdx = 0;
        int qmPosition = this.qmPositions.get(parameterIdx);
        for (int idx = 0; idx < this.qmTemplate.length(); ++idx) {
            if (idx == qmPosition) {
                QueryParameter parameter = this.orderedParameters.get(parameterIdx);
                if (parameter.value() == null) {
                    LOGGER.warn("Setting a parameter to NULL usually indicates a mistake (write IS [NOT] NULL instead), given: stmt={}, parameterIdx={}, parameter={}", new Object[]{sb, parameterIdx + 1, parameter});
                }
                parameter.adlSqlType().getQueryParameterApplicator().applyUnsafe(sb, parameter, parameterIdx + 1);
                if (++parameterIdx >= this.qmPositions.size()) continue;
                qmPosition = this.qmPositions.get(parameterIdx);
                continue;
            }
            sb.append(this.qmTemplate.charAt(idx));
        }
    }

    private void applyUnsafeDebug(StringBuilder sb) {
        if (this.orderedParameters.isEmpty()) {
            sb.append(this.qmTemplate);
            return;
        }
        int parameterIdx = 0;
        int qmPosition = this.qmPositions.get(parameterIdx);
        for (int idx = 0; idx < this.qmTemplate.length(); ++idx) {
            if (idx == qmPosition) {
                QueryParameter parameter = this.orderedParameters.get(parameterIdx);
                try {
                    parameter.adlSqlType().getQueryParameterApplicator().applyUnsafe(sb, parameter, parameterIdx + 1);
                }
                catch (RuntimeException ex) {
                    LOGGER.error("Unable to append parameter value, given: parameter={}, stmt={}", new Object[]{parameter, sb, ex});
                    sb.append("<!ERR:");
                    sb.append(parameter.id());
                    sb.append("!>");
                }
                if (++parameterIdx >= this.qmPositions.size()) continue;
                qmPosition = this.qmPositions.get(parameterIdx);
                continue;
            }
            sb.append(this.qmTemplate.charAt(idx));
        }
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.applyUnsafeDebug(sb);
        }
        catch (RuntimeException ex) {
            LOGGER.error("Unable to create debug string.", (Throwable)ex);
            return "<!ERR!>" + this.toString();
        }
        return sb.toString().trim();
    }

    private static class Builder
    implements QueryTemplateParser.ParameterListener {
        private final Map<String, QueryParameter> parameterMap;
        private final StringBuilder sbQuery = new StringBuilder();
        private final List<QueryParameter> orderedParameters = new ArrayList<QueryParameter>();
        private final List<Integer> qmPositions = new ArrayList<Integer>();
        private int lastPosition = 0;

        private Builder(String queryTemplate, List<QueryParameter> parameters) {
            this.parameterMap = Builder.createParameterMap(parameters);
            new QueryTemplateParser(this).parseSqlTemplate(queryTemplate);
            if (queryTemplate.length() > this.lastPosition) {
                this.sbQuery.append(queryTemplate.substring(this.lastPosition, queryTemplate.length()));
            }
        }

        private QueryTemplateWithParameters get() {
            return new QueryTemplateWithParameters(this.sbQuery.toString(), this.orderedParameters, this.qmPositions);
        }

        @Override
        public void handleParameter(String id, String template, int fromIdx, int toIdx) {
            QueryParameter parameter = this.parameterMap.get(id);
            if (parameter == null) {
                throw new QueryPreparationException(String.format("Unknown parameter: id=%s referenced at position=%s in template=%s", id, fromIdx, template));
            }
            this.orderedParameters.add(parameter);
            if (fromIdx > this.lastPosition) {
                this.sbQuery.append(template.substring(this.lastPosition, fromIdx));
            }
            this.qmPositions.add(this.sbQuery.length());
            this.sbQuery.append('?');
            this.lastPosition = toIdx;
        }

        private static Map<String, QueryParameter> createParameterMap(List<QueryParameter> parameters) {
            if (parameters == null) {
                throw new IllegalArgumentException("List of parameters must not be null.");
            }
            HashMap<String, QueryParameter> res = new HashMap<String, QueryParameter>();
            for (QueryParameter parameter : parameters) {
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Null element detected, given: %s", parameters));
                }
                QueryParameter prevParam = res.putIfAbsent(parameter.id(), parameter);
                if (prevParam == null || prevParam.equals(parameter)) continue;
                throw new IllegalArgumentException(String.format("Duplicate parameter id=%s detected, given: %s", parameter.id(), parameters));
            }
            return Collections.unmodifiableMap(res);
        }
    }
}

