/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql;

import de.calamanari.adl.sql.QueryPreparationException;

public class QueryTemplateParser {
    private final ParameterListener listener;

    public QueryTemplateParser(ParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null.");
        }
        this.listener = listener;
    }

    public void parseSqlTemplate(String template) {
        if (template == null) {
            throw new IllegalArgumentException("Template must not be null.");
        }
        int idx = 0;
        while (idx < template.length()) {
            char ch = template.charAt(idx);
            if (ch == '$' && idx < template.length() - 1 && template.charAt(idx + 1) == '{') {
                if ((idx = this.processCandidate(template, idx)) >= 0) continue;
                throw new QueryPreparationException(String.format("Error processing template %s, syntax error at position %s (parameter reference not closed, expected ${id}).", template, idx));
            }
            ++idx;
        }
    }

    private int processCandidate(String template, int fromIdx) {
        if (fromIdx + 2 >= template.length()) {
            return -1;
        }
        for (int idx = fromIdx + 2; idx < template.length(); ++idx) {
            char ch = template.charAt(idx);
            if (ch != '}') continue;
            String id = template.substring(fromIdx + 2, idx).trim();
            if (id.isEmpty()) {
                throw new QueryPreparationException(String.format("Error processing template %s, syntax error at position %s (expected ${id}).", template, fromIdx));
            }
            this.listener.handleParameter(id, template, fromIdx, idx + 1);
            return idx + 1;
        }
        return -1;
    }

    public static interface ParameterListener {
        public void handleParameter(String var1, String var2, int var3, int var4);
    }
}

