/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql;

import de.calamanari.adl.cnv.tps.AdlFormattingException;
import de.calamanari.adl.cnv.tps.ArgValueFormatter;
import de.calamanari.adl.cnv.tps.DefaultArgValueFormatter;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.util.TriFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public enum DefaultSqlFormatter implements ArgValueFormatter
{
    SQL_BIT((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlBit)),
    SQL_BIGINT((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.INTEGER).format(arg_0, arg_1, arg_2))),
    SQL_BOOLEAN((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlBoolean)),
    SQL_CHAR((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.STRING_IN_SINGLE_QUOTES).format(arg_0, arg_1, arg_2))),
    SQL_DATE_PLAIN((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlDatePlain)),
    SQL_DATE_DEFAULT((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlDateDefaultStyle)),
    SQL_DATE_MYSQL((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlDateMySqlStyle)),
    SQL_DATE_ORACLE((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlDateOracleStyle)),
    SQL_DATE_SQL_SERVER((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlDateSqlServerStyle)),
    SQL_DECIMAL((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.DECIMAL).format(arg_0, arg_1, arg_2))),
    SQL_DOUBLE((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.DECIMAL).format(arg_0, arg_1, arg_2))),
    SQL_FLOAT((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.DECIMAL).format(arg_0, arg_1, arg_2))),
    SQL_INTEGER((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlInteger)),
    SQL_LONGNVARCHAR((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.STRING_IN_SINGLE_QUOTES).format(arg_0, arg_1, arg_2))),
    SQL_LONGVARCHAR((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.STRING_IN_SINGLE_QUOTES).format(arg_0, arg_1, arg_2))),
    SQL_NCHAR((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.STRING_IN_SINGLE_QUOTES).format(arg_0, arg_1, arg_2))),
    SQL_NUMERIC((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.DECIMAL).format(arg_0, arg_1, arg_2))),
    SQL_NVARCHAR((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.STRING_IN_SINGLE_QUOTES).format(arg_0, arg_1, arg_2))),
    SQL_REAL((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.DECIMAL).format(arg_0, arg_1, arg_2))),
    SQL_SMALLINT((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlSmallInt)),
    SQL_TIMESTAMP_PLAIN((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlTimestampPlain)),
    SQL_TIMESTAMP_DEFAULT((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlTimestampDefaultStyle)),
    SQL_TIMESTAMP_MYSQL((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlTimestampMySqlStyle)),
    SQL_TIMESTAMP_ORACLE((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlTimestampOracleStyle)),
    SQL_TIMESTAMP_SQL_SERVER((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlTimestampSqlServerStyle)),
    SQL_TINYINT((TriFunction<String, String, MatchOperator, String>)((TriFunction)DefaultSqlFormatter::formatSqlTinyInt)),
    SQL_VARCHAR((TriFunction<String, String, MatchOperator, String>)((TriFunction)(arg_0, arg_1, arg_2) -> ((DefaultArgValueFormatter)DefaultArgValueFormatter.STRING_IN_SINGLE_QUOTES).format(arg_0, arg_1, arg_2)));

    private final TriFunction<String, String, MatchOperator, String> formatterFunction;

    private DefaultSqlFormatter(TriFunction<String, String, MatchOperator, String> formatterFunction) {
        this.formatterFunction = formatterFunction;
    }

    public String format(String argName, String argValue, MatchOperator operator) {
        return (String)this.formatterFunction.apply((Object)argName, (Object)argValue, (Object)operator);
    }

    public static String formatSqlBit(String argName, String argValue, MatchOperator operator) {
        if ("TRUE".equals(argValue) || "1".equals(argValue)) {
            return "1";
        }
        if ("FALSE".equals(argValue) || "0".equals(argValue)) {
            return "0";
        }
        throw new AdlFormattingException(String.format("Unable to format argName=%s, argValue=%s, operator=%s (TRUE, 1, FALSE, 0 input expected).", argName, argValue, operator));
    }

    public static String formatSqlBoolean(String argName, String argValue, MatchOperator operator) {
        if ("TRUE".equals(argValue) || "1".equals(argValue)) {
            return "TRUE";
        }
        if ("FALSE".equals(argValue) || "0".equals(argValue)) {
            return "FALSE";
        }
        throw new AdlFormattingException(String.format("Unable to format argName=%s, argValue=%s, operator=%s (TRUE, 1, FALSE, 0 input expected).", argName, argValue, operator));
    }

    public static String formatSqlInteger(String argName, String argValue, MatchOperator operator) {
        String formatted = DefaultArgValueFormatter.INTEGER.format(argName, argValue, operator);
        long temp = Long.parseLong(formatted);
        if (temp < Integer.MIN_VALUE || temp > Integer.MAX_VALUE) {
            throw new AdlFormattingException(String.format("Unable to format argName=%s, argValue=%s, operator=%s (value out of sql integer range [%d, %d]).", argName, argValue, operator, Integer.MIN_VALUE, Integer.MAX_VALUE));
        }
        return formatted;
    }

    public static String formatSqlSmallInt(String argName, String argValue, MatchOperator operator) {
        String formatted = DefaultArgValueFormatter.INTEGER.format(argName, argValue, operator);
        long temp = Long.parseLong(formatted);
        if (temp < -32768L || temp > 32767L) {
            throw new AdlFormattingException(String.format("Unable to format argName=%s, argValue=%s, operator=%s (value out of small int range [%d, %d]).", argName, argValue, operator, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE));
        }
        return formatted;
    }

    public static String formatSqlTinyInt(String argName, String argValue, MatchOperator operator) {
        String formatted = DefaultArgValueFormatter.INTEGER.format(argName, argValue, operator);
        long temp = Long.parseLong(formatted);
        if (temp < 0L || temp > 255L) {
            throw new AdlFormattingException(String.format("Unable to format argName=%s, argValue=%s, operator=%s (value out of tiny int range [%d, %d]).", argName, argValue, operator, 0, 255));
        }
        return formatted;
    }

    public static String formatSqlTimestampPlain(String argName, String argValue, MatchOperator operator) {
        if (DefaultSqlFormatter.isFullTimestamp(argValue)) {
            return "'" + argValue + "'";
        }
        return "'" + DefaultArgValueFormatter.DATE.format(argName, argValue, operator) + " 00:00:00'";
    }

    public static String formatSqlTimestampDefaultStyle(String argName, String argValue, MatchOperator operator) {
        return "TIMESTAMP " + DefaultSqlFormatter.formatSqlTimestampPlain(argName, argValue, operator);
    }

    public static String formatSqlTimestampOracleStyle(String argName, String argValue, MatchOperator operator) {
        return "TO_TIMESTAMP(" + DefaultSqlFormatter.formatSqlTimestampPlain(argName, argValue, operator) + ", 'YYYY-MM-DD HH24:MI:SS')";
    }

    public static String formatSqlTimestampMySqlStyle(String argName, String argValue, MatchOperator operator) {
        return "TIMESTAMP(" + DefaultSqlFormatter.formatSqlTimestampPlain(argName, argValue, operator) + ")";
    }

    public static String formatSqlTimestampSqlServerStyle(String argName, String argValue, MatchOperator operator) {
        return "TO_TIMESTAMP(" + DefaultSqlFormatter.formatSqlTimestampPlain(argName, argValue, operator) + ")";
    }

    public static String formatSqlDatePlain(String argName, String argValue, MatchOperator operator) {
        return "'" + DefaultArgValueFormatter.DATE.format(argName, argValue, operator) + "'";
    }

    public static String formatSqlDateDefaultStyle(String argName, String argValue, MatchOperator operator) {
        return "DATE " + DefaultSqlFormatter.formatSqlDatePlain(argName, argValue, operator);
    }

    public static String formatSqlDateOracleStyle(String argName, String argValue, MatchOperator operator) {
        return "TO_DATE(" + DefaultSqlFormatter.formatSqlDatePlain(argName, argValue, operator) + ", 'YYYY-MM-DD')";
    }

    public static String formatSqlDateSqlServerStyle(String argName, String argValue, MatchOperator operator) {
        return "TO_DATE(" + DefaultSqlFormatter.formatSqlDatePlain(argName, argValue, operator) + ")";
    }

    public static String formatSqlDateMySqlStyle(String argName, String argValue, MatchOperator operator) {
        return "DATE(" + DefaultSqlFormatter.formatSqlDatePlain(argName, argValue, operator) + ")";
    }

    private static boolean isFullTimestamp(String argValue) {
        if (argValue != null && argValue.length() > 10) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                return argValue.equals(sdf.format(sdf.parse(argValue)));
            }
            catch (ParseException ex) {
                return false;
            }
        }
        return false;
    }
}

