/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql;

import de.calamanari.adl.cnv.tps.AdlFormattingException;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.DefaultAdlSqlType;
import de.calamanari.adl.sql.QueryParameter;
import de.calamanari.adl.sql.QueryParameterApplicator;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQueryParameterApplicator
implements QueryParameterApplicator {
    private static final long serialVersionUID = -8256020137586993340L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultQueryParameterApplicator.class);
    private static final DefaultQueryParameterApplicator INSTANCE = new DefaultQueryParameterApplicator();

    public static final DefaultQueryParameterApplicator getInstance() {
        return INSTANCE;
    }

    private DefaultQueryParameterApplicator() {
    }

    @Override
    public void apply(PreparedStatement stmt, QueryParameter parameter, int parameterIndex) throws SQLException {
        try {
            if (parameter.value() != null) {
                AdlSqlType adlSqlType = parameter.adlSqlType().getBaseType();
                if (adlSqlType instanceof DefaultAdlSqlType) {
                    DefaultAdlSqlType baseType = (DefaultAdlSqlType)adlSqlType;
                    switch (baseType) {
                        case SQL_BIGINT: {
                            stmt.setLong(parameterIndex, (Long)parameter.value());
                            break;
                        }
                        case SQL_BIT: 
                        case SQL_BOOLEAN: {
                            stmt.setBoolean(parameterIndex, (Boolean)parameter.value());
                            break;
                        }
                        case SQL_CHAR: 
                        case SQL_LONGNVARCHAR: 
                        case SQL_LONGVARCHAR: 
                        case SQL_NCHAR: 
                        case SQL_NVARCHAR: 
                        case SQL_VARCHAR: {
                            stmt.setString(parameterIndex, (String)((Object)parameter.value()));
                            break;
                        }
                        case SQL_DATE: {
                            stmt.setDate(parameterIndex, (Date)parameter.value());
                            break;
                        }
                        case SQL_DECIMAL: 
                        case SQL_DOUBLE: 
                        case SQL_REAL: {
                            stmt.setDouble(parameterIndex, (Double)parameter.value());
                            break;
                        }
                        case SQL_FLOAT: {
                            stmt.setFloat(parameterIndex, ((Float)parameter.value()).floatValue());
                            break;
                        }
                        case SQL_INTEGER: {
                            stmt.setInt(parameterIndex, (Integer)parameter.value());
                            break;
                        }
                        case SQL_TINYINT: {
                            stmt.setByte(parameterIndex, (Byte)parameter.value());
                            break;
                        }
                        case SQL_NUMERIC: {
                            stmt.setBigDecimal(parameterIndex, (BigDecimal)parameter.value());
                            break;
                        }
                        case SQL_SMALLINT: {
                            stmt.setShort(parameterIndex, (Short)parameter.value());
                            break;
                        }
                        case SQL_TIMESTAMP: {
                            stmt.setTimestamp(parameterIndex, (Timestamp)parameter.value());
                        }
                    }
                    return;
                }
                throw new SQLException(String.format("Unsupported type: %s (not implemented, yet)", parameter.adlSqlType()));
            }
            stmt.setNull(parameterIndex, parameter.adlSqlType().getJavaSqlType());
        }
        catch (SQLException ex) {
            LOGGER.error(String.format("Unable to set a parameter at a prepared statement, given: adlSqlType=%s, value=%s, stmt=%s, parameterIndex=%s", parameter.adlSqlType(), parameter.value(), stmt, parameterIndex));
            throw ex;
        }
    }

    @Override
    public void applyUnsafe(StringBuilder sb, QueryParameter parameter, int parameterIndex) {
        if (parameter.value() != null) {
            AdlSqlType adlSqlType = parameter.adlSqlType().getBaseType();
            if (adlSqlType instanceof DefaultAdlSqlType) {
                DefaultAdlSqlType baseType = (DefaultAdlSqlType)adlSqlType;
                switch (baseType) {
                    case SQL_BIGINT: 
                    case SQL_CHAR: 
                    case SQL_LONGNVARCHAR: 
                    case SQL_LONGVARCHAR: 
                    case SQL_NCHAR: 
                    case SQL_NVARCHAR: 
                    case SQL_VARCHAR: 
                    case SQL_INTEGER: 
                    case SQL_SMALLINT: {
                        sb.append(DefaultQueryParameterApplicator.formatDefault(parameter));
                        break;
                    }
                    case SQL_TINYINT: {
                        sb.append(DefaultQueryParameterApplicator.formatTinyInt(parameter));
                        break;
                    }
                    case SQL_BIT: 
                    case SQL_BOOLEAN: {
                        boolean booleanVal = (Boolean)parameter.value();
                        sb.append(parameter.adlSqlType().getFormatter().format(parameter.id(), booleanVal ? "TRUE" : "FALSE", parameter.operator()));
                        break;
                    }
                    case SQL_TIMESTAMP: {
                        sb.append(DefaultQueryParameterApplicator.formatTimestamp(parameter));
                        break;
                    }
                    case SQL_DATE: {
                        sb.append(DefaultQueryParameterApplicator.formatDate(parameter));
                        break;
                    }
                    case SQL_DECIMAL: 
                    case SQL_DOUBLE: 
                    case SQL_REAL: {
                        sb.append(DefaultQueryParameterApplicator.formatDecimal(parameter, (Double)parameter.value()));
                        break;
                    }
                    case SQL_FLOAT: {
                        sb.append(DefaultQueryParameterApplicator.formatDecimal(parameter, ((Float)parameter.value()).floatValue()));
                        break;
                    }
                    case SQL_NUMERIC: {
                        sb.append(DefaultQueryParameterApplicator.formatDecimal(parameter, ((BigDecimal)parameter.value()).doubleValue()));
                    }
                }
                return;
            }
            throw new AdlFormattingException(String.format("Unsupported type: %s (not implemented, yet)", parameter));
        }
        sb.append("NULL");
    }

    private static String formatDecimal(QueryParameter parameter, double value) {
        NumberFormat nfDouble = NumberFormat.getInstance(Locale.US);
        nfDouble.setMaximumFractionDigits(7);
        nfDouble.setMinimumFractionDigits(1);
        nfDouble.setGroupingUsed(false);
        return parameter.adlSqlType().getFormatter().format(parameter.id(), nfDouble.format(value), parameter.operator());
    }

    private static String formatDate(QueryParameter parameter) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return parameter.adlSqlType().getFormatter().format(parameter.id(), sdf.format((Date)parameter.value()), parameter.operator());
    }

    private static String formatTimestamp(QueryParameter parameter) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return parameter.adlSqlType().getFormatter().format(parameter.id(), sdf.format((Timestamp)parameter.value()), parameter.operator());
    }

    private static String formatTinyInt(QueryParameter parameter) {
        int value = Byte.toUnsignedInt((Byte)parameter.value());
        return parameter.adlSqlType().getFormatter().format(parameter.id(), String.valueOf(value), parameter.operator());
    }

    private static String formatDefault(QueryParameter parameter) {
        return parameter.adlSqlType().getFormatter().format(parameter.id(), String.valueOf(parameter.value()), parameter.operator());
    }

    Object readResolve() {
        return INSTANCE;
    }
}

