/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql;

import de.calamanari.adl.cnv.tps.ArgValueFormatter;
import de.calamanari.adl.cnv.tps.NativeTypeCaster;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.QueryParameterApplicator;
import de.calamanari.adl.sql.QueryParameterCreator;
import java.util.concurrent.atomic.AtomicInteger;

public class AdlSqlTypeDecorator
implements AdlSqlType {
    private static final long serialVersionUID = 2654441110457026318L;
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private final AdlSqlType delegate;
    private final ArgValueFormatter formatter;
    private final NativeTypeCaster nativeTypeCaster;
    private final QueryParameterCreator queryParameterCreator;
    private final QueryParameterApplicator queryParameterApplicator;
    private final String decoratorName;

    @Override
    public AdlSqlType getBaseType() {
        return this.delegate.getBaseType();
    }

    AdlSqlTypeDecorator(String name, AdlSqlType delegate, ArgValueFormatter formatter, NativeTypeCaster nativeTypeCaster, QueryParameterCreator queryParameterCreator, QueryParameterApplicator queryParameterApplicator) {
        this.delegate = delegate;
        this.formatter = formatter;
        this.nativeTypeCaster = nativeTypeCaster;
        this.queryParameterCreator = queryParameterCreator;
        this.queryParameterApplicator = queryParameterApplicator;
        if (name != null) {
            this.decoratorName = name;
        } else if (delegate instanceof AdlSqlTypeDecorator) {
            AdlSqlTypeDecorator dec = (AdlSqlTypeDecorator)delegate;
            this.decoratorName = dec.getBaseName() + "-" + INSTANCE_COUNTER.incrementAndGet();
        } else {
            this.decoratorName = delegate.name() + "-" + INSTANCE_COUNTER.incrementAndGet();
        }
    }

    private String getBaseName() {
        AdlSqlType adlSqlType = this.delegate;
        if (adlSqlType instanceof AdlSqlTypeDecorator) {
            AdlSqlTypeDecorator dec = (AdlSqlTypeDecorator)adlSqlType;
            return dec.getBaseName();
        }
        return this.delegate.name();
    }

    public String name() {
        return this.decoratorName;
    }

    public ArgValueFormatter getFormatter() {
        return this.formatter == null ? this.delegate.getFormatter() : this.formatter;
    }

    public NativeTypeCaster getNativeTypeCaster() {
        return this.nativeTypeCaster == null ? this.delegate.getNativeTypeCaster() : this.nativeTypeCaster;
    }

    public boolean supportsContains() {
        return this.delegate.supportsContains();
    }

    public boolean supportsLessThanGreaterThan() {
        return this.delegate.supportsLessThanGreaterThan();
    }

    @Override
    public int getJavaSqlType() {
        return this.delegate.getJavaSqlType();
    }

    @Override
    public QueryParameterCreator getQueryParameterCreator() {
        return this.queryParameterCreator == null ? this.delegate.getQueryParameterCreator() : this.queryParameterCreator;
    }

    @Override
    public QueryParameterApplicator getQueryParameterApplicator() {
        return this.queryParameterApplicator == null ? this.delegate.getQueryParameterApplicator() : this.queryParameterApplicator;
    }

    public String toString() {
        return this.decoratorName;
    }
}

