/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.sql.config.SqlContainsPolicy;
import java.util.concurrent.atomic.AtomicInteger;

public class SqlContainsPolicyDecorator
implements SqlContainsPolicy {
    private static final long serialVersionUID = 7131812266291596818L;
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private final SqlContainsPolicy delegate;
    private final SqlContainsPolicy.PreparatorFunction prepareSearchSnippetFunction;
    private final SqlContainsPolicy.CreatorFunction createInstructionFunction;
    private final String decoratorName;

    SqlContainsPolicyDecorator(String name, SqlContainsPolicy delegate, SqlContainsPolicy.PreparatorFunction prepareSearchSnippetFunction, SqlContainsPolicy.CreatorFunction createInstructionFunction) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate must not be null.");
        }
        this.delegate = delegate;
        this.prepareSearchSnippetFunction = prepareSearchSnippetFunction;
        this.createInstructionFunction = createInstructionFunction;
        if (name != null) {
            this.decoratorName = name;
        } else if (delegate instanceof SqlContainsPolicyDecorator) {
            SqlContainsPolicyDecorator dec = (SqlContainsPolicyDecorator)delegate;
            this.decoratorName = dec.getBaseName() + "-" + INSTANCE_COUNTER.incrementAndGet();
        } else {
            this.decoratorName = delegate.name() + "-" + INSTANCE_COUNTER.incrementAndGet();
        }
    }

    private String getBaseName() {
        SqlContainsPolicy sqlContainsPolicy = this.delegate;
        if (sqlContainsPolicy instanceof SqlContainsPolicyDecorator) {
            SqlContainsPolicyDecorator dec = (SqlContainsPolicyDecorator)sqlContainsPolicy;
            return dec.getBaseName();
        }
        return this.delegate.name();
    }

    @Override
    public String prepareSearchSnippet(String value) {
        if (this.prepareSearchSnippetFunction != null) {
            return (String)this.prepareSearchSnippetFunction.apply(value);
        }
        return this.delegate.prepareSearchSnippet(value);
    }

    @Override
    public String createInstruction(String columnName, String patternParameter) {
        if (this.createInstructionFunction != null) {
            return (String)this.createInstructionFunction.apply(columnName, patternParameter);
        }
        return this.delegate.createInstruction(columnName, patternParameter);
    }

    @Override
    public String name() {
        return this.decoratorName;
    }

    public String toString() {
        return this.decoratorName;
    }
}

