/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.ProcessContext;
import de.calamanari.adl.cnv.tps.ArgMetaInfoLookup;
import de.calamanari.adl.cnv.tps.ConfigException;
import de.calamanari.adl.cnv.tps.LookupException;
import de.calamanari.adl.sql.config.AbstractTableBuilder;
import de.calamanari.adl.sql.config.ArgColumnAssignment;
import de.calamanari.adl.sql.config.CompositeAutoMappingPolicy;
import de.calamanari.adl.sql.config.ConfigBuilderInterfaces;
import de.calamanari.adl.sql.config.ConfigUtils;
import de.calamanari.adl.sql.config.DataTableConfig;
import de.calamanari.adl.sql.config.SingleTableConfig;
import de.calamanari.adl.sql.config.TableMetaInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public record MultiTableConfig(List<SingleTableConfig> tableConfigs) implements DataTableConfig
{
    public MultiTableConfig(List<SingleTableConfig> tableConfigs) {
        if (tableConfigs == null || tableConfigs.isEmpty()) {
            throw new ConfigException("tableConfigs must not be null or empty, given: " + String.valueOf(tableConfigs));
        }
        TreeMap<String, SingleTableConfig> tempMap = new TreeMap<String, SingleTableConfig>();
        HashSet<String> mappedArgNames = new HashSet<String>();
        String primaryTable = null;
        for (SingleTableConfig tableConfig : tableConfigs) {
            if (tableConfig == null) {
                throw new ConfigException("tableConfigs contains illegal null-entry, given: " + String.valueOf(tableConfigs));
            }
            SingleTableConfig prevEntry = tempMap.putIfAbsent(tableConfig.tableName(), tableConfig);
            if (prevEntry != null) {
                throw new ConfigException(String.format("Duplicate entry detected for tableName=%s, given: tableConfigs=%s", tableConfig.tableName(), tableConfigs));
            }
            primaryTable = this.validatePrimaryTable(tableConfigs, tableConfig, primaryTable);
            for (String argName : tableConfig.argColumnMap().keySet()) {
                if (mappedArgNames.contains(argName)) {
                    throw new ConfigException(String.format("Duplicate mapping detected for argName=%s, given: tableConfigs=%s", argName, tableConfigs), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
                }
                mappedArgNames.add(argName);
            }
        }
        this.tableConfigs = Collections.unmodifiableList(new ArrayList(tempMap.values()));
    }

    public static ConfigBuilderInterfaces.MultiTableStep1 withTable(String tableName) {
        return new Builder(null).withTable(tableName);
    }

    public static ConfigBuilderInterfaces.MultiTableAddTableOrExit withTable(SingleTableConfig table) {
        return new Builder(null).withTable(table);
    }

    public static ConfigBuilderInterfaces.MultiTableStep1 withTable(String tableName, ArgMetaInfoLookup argMetaInfoLookup) {
        return new Builder(argMetaInfoLookup).withTable(tableName);
    }

    public static ConfigBuilderInterfaces.MultiTableAddTableOrExit withTable(SingleTableConfig table, ArgMetaInfoLookup argMetaInfoLookup) {
        return new Builder(argMetaInfoLookup).withTable(table);
    }

    private String validatePrimaryTable(List<SingleTableConfig> tableConfigs, SingleTableConfig tableConfig, String primaryTable) {
        if (tableConfig.tableNature().isPrimaryTable()) {
            if (primaryTable != null) {
                throw new ConfigException(String.format("Duplicate primary table detected: %s vs. %s, given: tableConfigs=%s", primaryTable, tableConfig.tableName(), tableConfigs));
            }
            primaryTable = tableConfig.tableName();
        }
        return primaryTable;
    }

    public boolean contains(String argName) {
        return this.tableConfigs.stream().anyMatch(tc -> tc.contains(argName));
    }

    @Override
    public ArgColumnAssignment lookupAssignment(String argName, ProcessContext ctx) {
        ConfigUtils.assertContextNotNull(ctx);
        return this.tableConfigs.stream().filter(tc -> tc.contains(argName)).findAny().orElseThrow(() -> new LookupException("No meta data available for argName=" + argName, AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]))).lookupAssignment(argName, ctx);
    }

    @Override
    public int numberOfTables() {
        return this.tableConfigs.size();
    }

    @Override
    public TableMetaInfo lookupTableMetaInfo(String argName, ProcessContext ctx) {
        ConfigUtils.assertContextNotNull(ctx);
        return this.tableConfigs.stream().filter(tc -> tc.contains(argName)).findAny().orElseThrow(() -> new LookupException("No TableMetaInfo available for argName=" + argName, AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0])));
    }

    @Override
    public List<TableMetaInfo> allTableMetaInfos() {
        List<TableMetaInfo> res = this.tableConfigs;
        return res;
    }

    private static class Builder
    extends AbstractTableBuilder<Builder>
    implements ConfigBuilderInterfaces.MultiTableDataColumnStep1a,
    ConfigBuilderInterfaces.MultiTableAddTable,
    ConfigBuilderInterfaces.MultiTableStep1,
    ConfigBuilderInterfaces.MultiTableStep2,
    ConfigBuilderInterfaces.MultiTableDataColumnStep2 {
        private final List<SingleTableConfig> tableConfigs = new ArrayList<SingleTableConfig>();
        private boolean havePendingTable = false;

        private Builder(ArgMetaInfoLookup argMetaInfoLookup) {
            super(argMetaInfoLookup);
        }

        @Override
        public ConfigBuilderInterfaces.MultiTableStep1 withTable(String tableName) {
            this.addPendingTable();
            this.tableName = tableName;
            this.havePendingTable = true;
            return this;
        }

        @Override
        public ConfigBuilderInterfaces.MultiTableAddTableOrExit withTable(SingleTableConfig table) {
            this.addPendingTable();
            this.tableConfigs.add(table);
            return this;
        }

        private void addPendingTable() {
            if (this.havePendingTable) {
                super.addPendingColumn();
                this.tableConfigs.add(new SingleTableConfig(this.tableName, this.idColumnName, this.determineTableNature(), this.tableFilterColumns, this.argColumnMap, new CompositeAutoMappingPolicy(this.autoMappingPolicies)));
                this.tableName = null;
                this.argColumnMap.clear();
                this.containsAllIdsFlag = false;
                this.sparseFlag = false;
                this.uniqueIdsFlag = false;
                this.primaryTableFlag = false;
                this.haveDataColumns = false;
                this.autoMappingPolicies.clear();
                this.tableFilterColumns.clear();
                this.havePendingTable = false;
            }
        }

        @Override
        public MultiTableConfig get() {
            this.addPendingTable();
            return new MultiTableConfig(this.tableConfigs);
        }
    }
}

