/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.cnv.TemplateParameterUtils;
import de.calamanari.adl.cnv.tps.AdlFormattingException;
import de.calamanari.adl.cnv.tps.ConfigException;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.config.AdlSqlColumn;
import de.calamanari.adl.sql.config.ConfigUtils;

public record FilterColumn(String tableName, String columnName, AdlSqlType columnType, String filterValue) implements AdlSqlColumn
{
    public static final String VAR_ARG_NAME = "argName";
    public static final String ARG_NAME_PLACEHOLDER = "${argName}";

    public FilterColumn {
        if (!ConfigUtils.isValidTableName(tableName) || !ConfigUtils.isValidColumnName(columnName) || columnType == null || filterValue == null) {
            throw new ConfigException(String.format("None of the arguments can be null and columnName/tableName must be valid SQL identifiers, given: tableName=%s, columnName=%s, columnType=%s, filterValue=%s.", tableName, columnName, columnType, filterValue));
        }
        try {
            String value = FilterColumn.createNativeValue(tableName, columnName, columnType, filterValue);
            if (value.isBlank()) {
                throw new ConfigException(String.format("The given filterValue formatted in the given way would result in a broken blank value (>>%s<<), given: tableName=%s, columnName=%s, columnType=%s, filterValue=%s.", value, tableName, columnName, columnType, filterValue));
            }
        }
        catch (AdlFormattingException ex) {
            throw new ConfigException(String.format("The given filterValue cannot be formatted with the specified type, given: tableName=%s, columnName=%s, columnType=%s, filterValue=%s.", tableName, columnName, columnType, filterValue), (Throwable)ex);
        }
    }

    private static String createNativeValue(String tableName, String columnName, AdlSqlType columnType, String filterValue) {
        return TemplateParameterUtils.containsAnyVariables((String)filterValue) ? filterValue : columnType.getFormatter().format("<FilterColumn:" + tableName + "." + columnName + ">", filterValue, MatchOperator.EQUALS);
    }

    private static String createNativeCondition(String tableName, String columnName, AdlSqlType columnType, String filterValue) {
        return tableName + "." + columnName + "=" + FilterColumn.createNativeValue(tableName, columnName, columnType, filterValue);
    }

    public String nativeCondition() {
        return FilterColumn.createNativeCondition(this.tableName, this.columnName, this.columnType, this.filterValue);
    }

    @Override
    public String toString() {
        return "?{ " + this.nativeCondition() + " }";
    }
}

