/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.ProcessContext;
import de.calamanari.adl.cnv.tps.ArgMetaInfo;
import de.calamanari.adl.cnv.tps.ConfigException;
import de.calamanari.adl.sql.config.ArgColumnAssignment;
import de.calamanari.adl.sql.config.AutoMappingPolicy;
import de.calamanari.adl.sql.config.ConfigUtils;
import java.io.Serializable;
import java.util.function.UnaryOperator;

public class DefaultAutoMappingPolicy
implements AutoMappingPolicy {
    private static final long serialVersionUID = 7860446717172333819L;
    public static final String VAR_ARG_NAME_LOCAL = "argName.local";
    public static final String ARG_NAME_LOCAL_PLACEHOLDER = "${argName.local}";
    public static final AutoMappingPolicy NONE = new AutoMappingPolicy(){
        private static final long serialVersionUID = 2854932785875792470L;

        @Override
        public ArgColumnAssignment map(String argName, ProcessContext settings) {
            throw new ConfigException("Auto-mapping error: NONE-mapper called for argName=" + argName, AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
        }

        @Override
        public boolean isApplicable(String argName) {
            return false;
        }

        Object readResolve() {
            return NONE;
        }
    };
    protected final ArgColumnAssignment assignmentTemplate;
    protected final LocalArgNameExtractor extractorFunction;

    public DefaultAutoMappingPolicy(LocalArgNameExtractor extractorFunction, ArgColumnAssignment assignmentTemplate) {
        if (extractorFunction == null) {
            throw new IllegalArgumentException("The extractorFunction for extracting argName.local from the argName must not be null, assignmentTemplate=" + String.valueOf(assignmentTemplate));
        }
        if (assignmentTemplate == null) {
            throw new IllegalArgumentException("The assignmentTemplate must not be null.");
        }
        this.extractorFunction = extractorFunction;
        this.assignmentTemplate = assignmentTemplate;
    }

    @Override
    public boolean isApplicable(String argName) {
        return this.extractorFunction.apply(argName) != null;
    }

    protected void prepareVariables(String argName, ProcessContext ctx) {
        ConfigUtils.assertContextNotNull(ctx);
        String argNameLocal = (String)this.extractorFunction.apply(argName);
        ctx.getGlobalVariables().put(VAR_ARG_NAME_LOCAL, argNameLocal);
    }

    @Override
    public ArgColumnAssignment map(String argName, ProcessContext ctx) {
        if (!this.isApplicable(argName)) {
            throw new ConfigException("Auto-mapping error: this mapper is not applicable to argName=" + argName, AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
        }
        this.prepareVariables(argName, ctx);
        ArgMetaInfo argTemplate = this.assignmentTemplate.arg();
        ArgMetaInfo arg = new ArgMetaInfo(argName, argTemplate.type(), argTemplate.isAlwaysKnown(), argTemplate.isCollection());
        return new ArgColumnAssignment(arg, this.assignmentTemplate.column());
    }

    public static interface LocalArgNameExtractor
    extends UnaryOperator<String>,
    Serializable {
    }
}

