/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.ProcessContext;
import de.calamanari.adl.cnv.tps.ArgMetaInfo;
import de.calamanari.adl.cnv.tps.ArgMetaInfoLookup;
import de.calamanari.adl.cnv.tps.LookupException;
import de.calamanari.adl.sql.config.ArgColumnAssignment;
import de.calamanari.adl.sql.config.DataColumn;
import de.calamanari.adl.sql.config.TableMetaInfo;
import java.util.Arrays;
import java.util.List;

public interface DataTableConfig
extends ArgMetaInfoLookup {
    public ArgColumnAssignment lookupAssignment(String var1, ProcessContext var2);

    public int numberOfTables();

    default public int numberOfTablesInvolved(List<String> argNames, ProcessContext ctx) {
        return this.tablesInvolved(argNames, ctx).size();
    }

    default public List<String> tablesInvolved(List<String> argNames, ProcessContext ctx) {
        return this.tableMetaInfosInvolved(argNames, ctx).stream().map(TableMetaInfo::tableName).distinct().toList();
    }

    default public ArgMetaInfo lookup(String argName) {
        if (argName == null) {
            throw new IllegalArgumentException("Parameter argName must not be null.");
        }
        return this.lookupAssignment(argName, ProcessContext.empty()).arg();
    }

    default public DataColumn lookupColumn(String argName, ProcessContext ctx) {
        if (argName == null) {
            throw new IllegalArgumentException("Parameter argName must not be null.");
        }
        return this.lookupAssignment(argName, ctx).column();
    }

    public TableMetaInfo lookupTableMetaInfo(String var1, ProcessContext var2);

    public List<TableMetaInfo> allTableMetaInfos();

    default public List<TableMetaInfo> tableMetaInfosInvolved(List<String> argNames, ProcessContext ctx) {
        return argNames.stream().map(argName -> this.lookupTableMetaInfo((String)argName, ctx)).distinct().toList();
    }

    default public List<String> tablesThatContainAllIds() {
        if (this.allTableMetaInfos().size() == 1) {
            return Arrays.asList(this.allTableMetaInfos().get(0).tableName());
        }
        return this.allTableMetaInfos().stream().filter(info -> info.tableNature().containsAllIds()).map(TableMetaInfo::tableName).toList();
    }

    default public String primaryTable() {
        return this.allTableMetaInfos().stream().filter(info -> info.tableNature().isPrimaryTable()).findFirst().map(TableMetaInfo::tableName).orElse(null);
    }

    default public TableMetaInfo lookupTableMetaInfoByTableName(String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName must not be null.");
        }
        return this.allTableMetaInfos().stream().filter(info -> info.tableName().equals(tableName)).findFirst().orElseThrow(() -> new LookupException(String.format("No meta information available for table %s", tableName)));
    }
}

