/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.cnv.tps.ConfigException;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.config.AdlSqlColumn;
import de.calamanari.adl.sql.config.ConfigBuilderInterfaces;
import de.calamanari.adl.sql.config.ConfigUtils;
import de.calamanari.adl.sql.config.FilterColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public record DataColumn(String tableName, String columnName, AdlSqlType columnType, boolean isAlwaysKnown, boolean isMultiRow, List<FilterColumn> filters) implements AdlSqlColumn
{
    public DataColumn(String tableName, String columnName, AdlSqlType columnType, boolean isAlwaysKnown, boolean isMultiRow, List<FilterColumn> filters) {
        if (!ConfigUtils.isValidTableName(tableName) || !ConfigUtils.isValidColumnName(columnName) || columnType == null) {
            throw new ConfigException(String.format("Arguments tableName, columnName and columnType must not be null, tableName and columnName must be valid SQL identifiers, given: tableName=%s, columnName=%s, columnType=%s", tableName, columnName, columnType));
        }
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnType = columnType;
        this.isAlwaysKnown = isAlwaysKnown;
        this.isMultiRow = isMultiRow;
        if (filters != null && !filters.isEmpty()) {
            DataColumn.validateFilters(tableName, columnName, columnType, filters);
            this.filters = Collections.unmodifiableList(new ArrayList<FilterColumn>(filters));
        } else {
            this.filters = Collections.emptyList();
        }
    }

    public static ConfigBuilderInterfaces.DataColumnStep1 forTable(String tableName) {
        return new Builder(tableName);
    }

    private static void validateFilters(String tableName, String columnName, AdlSqlType columnType, List<FilterColumn> filters) {
        HashMap<String, FilterColumn> filterMap = new HashMap<String, FilterColumn>();
        for (FilterColumn filter : filters) {
            if (filter == null) {
                throw new ConfigException(String.format("List of filters must not contain any nulls, given: tableName=%s, columnName=%s, columnType=%s, filters=%s", tableName, columnName, columnType, filters));
            }
            if (!filter.tableName().equals(tableName)) {
                throw new ConfigException(String.format("Filter column must belong to the same table, given: tableName=%s, columnName=%s, columnType=%s, filters=%s", tableName, columnName, columnType, filters));
            }
            if (filter.columnName().equals(columnName)) {
                throw new ConfigException(String.format("Filter column must not equal the base column, given: tableName=%s, columnName=%s, columnType=%s, filters=%s", tableName, columnName, columnType, filters));
            }
            FilterColumn prevValue = filterMap.putIfAbsent(filter.columnName(), filter);
            if (prevValue == null) continue;
            throw new ConfigException(String.format("Duplicate filter column %s, given: tableName=%s, columnName=%s, columnType=%s, filters=%s", filter.columnName(), tableName, columnName, columnType, filters));
        }
    }

    private static class Builder
    implements ConfigBuilderInterfaces.DataColumnStep1,
    ConfigBuilderInterfaces.DataColumnStep2 {
        private final String tableName;
        private String columnName;
        private AdlSqlType columnType;
        private boolean multiRowFlag = false;
        private boolean alwaysKnownFlag = false;
        private List<FilterColumn> filterColumns = new ArrayList<FilterColumn>();

        private Builder(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public ConfigBuilderInterfaces.DataColumnStep2 dataColumn(String columnName, AdlSqlType columnType) {
            this.columnName = columnName;
            this.columnType = columnType;
            return this;
        }

        @Override
        public ConfigBuilderInterfaces.DataColumnStep4 multiRow() {
            this.multiRowFlag = true;
            return this;
        }

        @Override
        public ConfigBuilderInterfaces.DataColumnStep4 filteredBy(String columnName, AdlSqlType columnType, String value) {
            this.filterColumns.add(new FilterColumn(this.tableName, columnName, columnType, value));
            return this;
        }

        @Override
        public ConfigBuilderInterfaces.DataColumnStep3 alwaysKnown() {
            this.alwaysKnownFlag = true;
            return this;
        }

        @Override
        public DataColumn get() {
            return new DataColumn(this.tableName, this.columnName, this.columnType, this.alwaysKnownFlag, this.multiRowFlag, this.filterColumns);
        }
    }
}

