/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.ProcessContext;

public class ConfigUtils {
    public static void assertValidArgName(String argName) {
        if (!ConfigUtils.isValidArgName(argName)) {
            throw new IllegalArgumentException("Parameter argName must not be null or empty.");
        }
    }

    public static void assertContextNotNull(ProcessContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("The process context must not not be null, use ProcessContext.empty() instead to call this method without any settings.");
        }
    }

    public static boolean isValidArgName(String argName) {
        return argName != null && !argName.isBlank();
    }

    public static boolean isValidTableName(String name) {
        return ConfigUtils.isValidSqlName(name, false);
    }

    public static boolean isValidColumnName(String name) {
        return ConfigUtils.isValidSqlName(name, true);
    }

    private static boolean isValidSqlName(String name, boolean isColumn) {
        if (name == null || name.isBlank()) {
            return false;
        }
        if (name.startsWith("`") && name.endsWith("`")) {
            return ConfigUtils.isValidSqlNameBT(name);
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ConfigUtils.isPlainIdChar(ch) || ch == '.' && !isColumn && i > 0 && i < name.length() - 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isPlainIdChar(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '$' || ch == '_';
    }

    private static boolean isValidSqlNameBT(String name) {
        String innerName = name.substring(1, name.length() - 1);
        return !innerName.isBlank() && innerName.indexOf(96) < 0;
    }

    private ConfigUtils() {
    }
}

