/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.CombinedExpressionType;
import de.calamanari.adl.cnv.ConversionContext;
import de.calamanari.adl.irl.CoreExpression;
import de.calamanari.adl.sql.cnv.SqlConversionProcessContext;
import java.util.ArrayList;
import java.util.List;

public class SqlConversionContext
implements ConversionContext {
    private SqlConversionProcessContext processContext;
    private final List<CoreExpression> skippedChildExpressions = new ArrayList<CoreExpression>();
    private boolean negation = false;
    private CombinedExpressionType combiType = CombinedExpressionType.AND;
    private boolean closingBraceSuppressed = false;

    public void skipChildExpression(CoreExpression expression) {
        this.skippedChildExpressions.add(expression);
    }

    public boolean isSkipped(CoreExpression expression) {
        return this.skippedChildExpressions.contains(expression);
    }

    public boolean isNegation() {
        return this.negation;
    }

    public void markNegation() {
        this.negation = true;
    }

    public CombinedExpressionType getCombiType() {
        return this.combiType;
    }

    public void setCombiType(CombinedExpressionType combiType) {
        this.combiType = combiType;
    }

    public void clear() {
        this.skippedChildExpressions.clear();
        this.negation = false;
        this.closingBraceSuppressed = false;
        this.combiType = CombinedExpressionType.AND;
    }

    public void setProcessContext(SqlConversionProcessContext processContext) {
        this.processContext = processContext;
    }

    public void suppressClosingBrace() {
        this.closingBraceSuppressed = true;
    }

    public boolean isClosingBraceSuppressed() {
        return this.closingBraceSuppressed;
    }

    public List<CoreExpression> getSkippedChildExpressions() {
        return this.skippedChildExpressions;
    }

    public SqlConversionProcessContext getProcessContext() {
        return this.processContext;
    }
}

