/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.CombinedExpressionType;
import de.calamanari.adl.Flag;
import de.calamanari.adl.ProcessContext;
import de.calamanari.adl.irl.CombinedExpression;
import de.calamanari.adl.irl.CoreExpression;
import de.calamanari.adl.irl.MatchExpression;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.irl.NegationExpression;
import de.calamanari.adl.irl.ParentAwareExpressionNode;
import de.calamanari.adl.irl.SimpleExpression;
import de.calamanari.adl.sql.cnv.ConversionDirective;
import de.calamanari.adl.sql.cnv.ConversionHint;
import de.calamanari.adl.sql.cnv.CoreExpressionSqlHelper;
import de.calamanari.adl.sql.config.DataBinding;
import de.calamanari.adl.sql.config.TableMetaInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

public record CoreExpressionStats(Set<Flag> hints, Set<String> argNames, Set<String> argNamesMarkedMultiRow, Set<String> argNamesWithMultiRowSensitivity, Set<String> argNamesInPositiveValueMatches, Set<String> argNamesInNegativeValueMatches, Set<String> argNamesInPositiveIsUnknownMatches, Set<String> argNamesInNegativeIsUnknownMatches, Set<String> requiredTables, boolean isSeparateBaseTableRequired) {
    public CoreExpressionStats(Set<Flag> hints, Set<String> argNames, Set<String> argNamesMarkedMultiRow, Set<String> argNamesWithMultiRowSensitivity, Set<String> argNamesInPositiveValueMatches, Set<String> argNamesInNegativeValueMatches, Set<String> argNamesInPositiveIsUnknownMatches, Set<String> argNamesInNegativeIsUnknownMatches, Set<String> requiredTables, boolean isSeparateBaseTableRequired) {
        if (hints == null || argNames == null || argNamesMarkedMultiRow == null || argNamesWithMultiRowSensitivity == null || argNamesInPositiveValueMatches == null || argNamesInNegativeValueMatches == null || argNamesInPositiveIsUnknownMatches == null || argNamesInNegativeIsUnknownMatches == null || requiredTables == null) {
            throw new IllegalArgumentException("Internal sets must not be null, given: " + String.valueOf(this));
        }
        this.hints = hints;
        this.argNames = argNames;
        this.argNamesMarkedMultiRow = argNamesMarkedMultiRow;
        this.argNamesWithMultiRowSensitivity = argNamesWithMultiRowSensitivity;
        this.argNamesInPositiveValueMatches = argNamesInPositiveValueMatches;
        this.argNamesInNegativeValueMatches = argNamesInNegativeValueMatches;
        this.argNamesInPositiveIsUnknownMatches = argNamesInPositiveIsUnknownMatches;
        this.argNamesInNegativeIsUnknownMatches = argNamesInNegativeIsUnknownMatches;
        this.requiredTables = requiredTables;
        this.isSeparateBaseTableRequired = isSeparateBaseTableRequired;
    }

    public static CoreExpressionStats from(CoreExpression expression, DataBinding dataBinding, ProcessContext ctx) {
        TreeSet<String> multiRowArgNames = new TreeSet<String>();
        TreeSet<String> argNamesInPositiveValueMatches = new TreeSet<String>();
        TreeSet<String> argNamesInNegativeValueMatches = new TreeSet<String>();
        TreeSet<String> argNamesInPositiveIsUnknownMatches = new TreeSet<String>();
        TreeSet<String> argNamesInNegativeIsUnknownMatches = new TreeSet<String>();
        TreeSet<String> argNamesWithMultiRowSensitivity = new TreeSet<String>();
        TreeSet<String> requiredTables = new TreeSet<String>(expression.allArgNames().stream().map(argName -> dataBinding.dataTableConfig().lookupTableMetaInfo((String)argName, ctx)).map(TableMetaInfo::tableName).distinct().toList());
        CoreExpressionStats.collectArgNamesInValueMatches(expression, e -> e.operator() != MatchOperator.IS_UNKNOWN, false, argNamesInPositiveValueMatches);
        CoreExpressionStats.collectArgNamesInValueMatches(expression, e -> e.operator() != MatchOperator.IS_UNKNOWN, true, argNamesInNegativeValueMatches);
        CoreExpressionStats.collectArgNamesInValueMatches(expression, e -> e.operator() == MatchOperator.IS_UNKNOWN, false, argNamesInPositiveIsUnknownMatches);
        CoreExpressionStats.collectArgNamesInValueMatches(expression, e -> e.operator() == MatchOperator.IS_UNKNOWN, true, argNamesInNegativeIsUnknownMatches);
        CoreExpressionStats.collectArgNamesMultiRowOrSparse(expression, dataBinding, ctx, multiRowArgNames);
        CoreExpressionStats.collectArgNamesWithIsNullMultiRowSensitivity(dataBinding, ctx, argNamesInPositiveIsUnknownMatches, argNamesWithMultiRowSensitivity);
        CoreExpressionStats.collectArgNamesWithMultiRowSensitivity(expression, dataBinding, ctx, multiRowArgNames, argNamesWithMultiRowSensitivity);
        CoreExpressionStats stats = new CoreExpressionStats(new TreeSet<Flag>(), argNamesWithMultiRowSensitivity, multiRowArgNames, argNamesWithMultiRowSensitivity, argNamesInPositiveValueMatches, argNamesInNegativeValueMatches, argNamesInPositiveIsUnknownMatches, argNamesInNegativeIsUnknownMatches, requiredTables, CoreExpressionStats.checkSeparateBaseTableRequired(expression, dataBinding, ctx));
        CoreExpressionStats.computeHints(expression, dataBinding, ctx, stats);
        return stats;
    }

    private static boolean checkSingleTableQuery(CoreExpressionStats stats, DataBinding dataBinding, ProcessContext ctx) {
        String primaryTableName = dataBinding.dataTableConfig().primaryTable();
        return stats.requiredTables.size() == 1 && (!ConversionDirective.ENFORCE_PRIMARY_TABLE.check(ctx.getGlobalFlags()) || primaryTableName != null && stats.requiredTables.contains(primaryTableName));
    }

    private static void computeHints(CoreExpression expression, DataBinding dataBinding, ProcessContext ctx, CoreExpressionStats stats) {
        if (expression.collectExpressions(e -> {
            MatchExpression match;
            return e instanceof MatchExpression && (match = (MatchExpression)e).operator() == MatchOperator.IS_UNKNOWN;
        }).isEmpty()) {
            stats.hints.add(ConversionHint.NO_IS_UNKNOWN);
        }
        if (expression.collectExpressions(e -> {
            MatchExpression match;
            return e instanceof MatchExpression && (match = (MatchExpression)e).referencedArgName() != null;
        }).isEmpty()) {
            stats.hints.add(ConversionHint.NO_REFERENCE_MATCH);
        }
        CoreExpressionStats.computeAndOrHints(expression, stats);
        if (expression.allArgNames().size() == 1) {
            stats.hints.add(ConversionHint.SINGLE_ATTRIBUTE);
        }
        if (CoreExpressionStats.checkSingleTableQuery(stats, dataBinding, ctx)) {
            stats.hints.add(ConversionHint.SINGLE_TABLE);
            TableMetaInfo tmi = dataBinding.dataTableConfig().lookupTableMetaInfoByTableName(stats.requiredTables.iterator().next());
            if (dataBinding.dataTableConfig().numberOfTables() == 1 || tmi.tableNature().containsAllIds()) {
                stats.hints.add(ConversionHint.SINGLE_TABLE_CONTAINING_ALL_ROWS);
            }
        }
        if (!CoreExpressionStats.containsMultiRowSensitiveReferenceMatch(expression, stats)) {
            stats.hints.add(ConversionHint.NO_MULTI_ROW_REFERENCE_MATCH);
        }
        if (CoreExpressionStats.checkSimpleSingleTableCondition(expression, dataBinding, ctx, stats)) {
            stats.hints.add(ConversionHint.SIMPLE_CONDITION);
        }
        CoreExpressionStats.computeComplexHints(dataBinding, ctx, stats);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void computeAndOrHints(CoreExpression expression, CoreExpressionStats stats) {
        if (expression instanceof SimpleExpression) {
            stats.hints.add(ConversionHint.NO_AND);
            stats.hints.add(ConversionHint.NO_OR);
            return;
        }
        if (expression instanceof CombinedExpression) {
            CombinedExpression cmb = (CombinedExpression)expression;
            if (!CoreExpressionSqlHelper.isSubNested(expression) && cmb.combiType() == CombinedExpressionType.OR) {
                stats.hints.add(ConversionHint.NO_AND);
                return;
            }
        }
        if (!(expression instanceof CombinedExpression)) return;
        CombinedExpression cmb = (CombinedExpression)expression;
        if (CoreExpressionSqlHelper.isSubNested(expression)) return;
        if (cmb.combiType() != CombinedExpressionType.AND) return;
        stats.hints.add(ConversionHint.NO_OR);
    }

    private static void computeComplexHints(DataBinding dataBinding, ProcessContext ctx, CoreExpressionStats stats) {
        if (stats.argNamesWithMultiRowSensitivity.isEmpty()) {
            stats.hints.add(ConversionHint.NO_MULTI_ROW_SENSITIVITY);
        }
        if (ConversionHint.SIMPLE_CONDITION.check(stats.hints) || ConversionHint.SINGLE_TABLE_CONTAINING_ALL_ROWS.check(stats.hints) && (ConversionHint.NO_AND.check(stats.hints) && ConversionHint.NO_MULTI_ROW_REFERENCE_MATCH.check(stats.hints) && ConversionHint.NO_IS_UNKNOWN.check(stats.hints) || ConversionHint.NO_MULTI_ROW_SENSITIVITY.check(stats.hints)) || ConversionHint.SINGLE_TABLE.check(stats.hints) && (ConversionHint.NO_AND.check(stats.hints) && ConversionHint.NO_MULTI_ROW_REFERENCE_MATCH.check(stats.hints) || ConversionHint.NO_MULTI_ROW_SENSITIVITY.check(stats.hints)) && ConversionHint.NO_IS_UNKNOWN.check(stats.hints)) {
            CoreExpressionStats.addSimpleJoinTypeHint(dataBinding, stats);
        } else {
            CoreExpressionStats.addComplexJoinTypeHint(dataBinding, ctx, stats);
        }
    }

    private static void addComplexJoinTypeHint(DataBinding dataBinding, ProcessContext ctx, CoreExpressionStats stats) {
        boolean innerJoinsPossible;
        boolean multiJoinConflictPossible = stats.argNamesInNegativeValueMatches.stream().map(argName -> dataBinding.dataTableConfig().lookupTableMetaInfo((String)argName, ctx)).anyMatch(tmi -> !tmi.tableNature().isIdUnique());
        boolean bl = innerJoinsPossible = ConversionHint.NO_MULTI_ROW_SENSITIVITY.check(stats.hints) && ConversionHint.NO_OR.check(stats.hints) && ConversionHint.NO_MULTI_ROW_REFERENCE_MATCH.check(stats.hints) && ConversionHint.NO_IS_UNKNOWN.check(stats.hints) && !multiJoinConflictPossible;
        if (!innerJoinsPossible) {
            stats.hints.add(ConversionHint.LEFT_OUTER_JOINS_REQUIRED);
        }
    }

    private static void addSimpleJoinTypeHint(DataBinding dataBinding, CoreExpressionStats stats) {
        TableMetaInfo tmi = dataBinding.dataTableConfig().lookupTableMetaInfoByTableName(stats.requiredTables().iterator().next());
        if (stats.argNamesInNegativeValueMatches.isEmpty() || tmi.tableNature().isIdUnique()) {
            stats.hints.add(ConversionHint.NO_JOINS_REQUIRED);
        } else {
            stats.hints.add(ConversionHint.LEFT_OUTER_JOINS_REQUIRED);
        }
    }

    public boolean isMultiRowSensitive(String argName) {
        return this.argNamesWithMultiRowSensitivity.contains(argName);
    }

    public boolean hasAnyMultiRowSensitiveArgs() {
        return !this.argNamesWithMultiRowSensitivity.isEmpty();
    }

    private static boolean checkSimpleSingleTableCondition(CoreExpression expression, DataBinding dataBinding, ProcessContext ctx, CoreExpressionStats stats) {
        if (!ConversionHint.SINGLE_TABLE.check(stats.hints)) {
            return false;
        }
        if (stats.hasAnyMultiRowSensitiveArgs()) {
            TableMetaInfo tmi = dataBinding.dataTableConfig().lookupTableMetaInfoByTableName(stats.requiredTables.iterator().next());
            return !(dataBinding.dataTableConfig().numberOfTables() != 1 && !tmi.tableNature().containsAllIds() && !stats.argNamesInPositiveIsUnknownMatches.isEmpty() || !ConversionHint.NO_AND.check(stats.hints) || !ConversionHint.NO_MULTI_ROW_REFERENCE_MATCH.check(stats.hints) || !stats.argNamesInNegativeValueMatches.isEmpty() && !tmi.tableNature().isIdUnique());
        }
        return CoreExpressionStats.checkSimpleSingleTableCondition(expression, dataBinding, ctx);
    }

    private static boolean containsMultiRowSensitiveReferenceMatch(CoreExpression expression, CoreExpressionStats stats) {
        CoreExpression coreExpression = expression;
        Objects.requireNonNull(coreExpression);
        CoreExpression coreExpression2 = coreExpression;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleExpression.class, CombinedExpression.class}, (Object)coreExpression2, n)) {
                case 0: {
                    SimpleExpression simple = (SimpleExpression)coreExpression2;
                    if (simple.referencedArgName() == null || !stats.isMultiRowSensitive(simple.argName()) && !stats.isMultiRowSensitive(simple.referencedArgName())) {
                        n = 1;
                        continue block4;
                    }
                    return true;
                }
                case 1: {
                    CombinedExpression cmb = (CombinedExpression)coreExpression2;
                    return cmb.members().stream().anyMatch(e -> CoreExpressionStats.containsMultiRowSensitiveReferenceMatch(e, stats));
                }
            }
            break;
        }
        return false;
    }

    private static boolean checkSimpleSingleTableCondition(CoreExpression expression, DataBinding dataBinding, ProcessContext ctx) {
        CoreExpression coreExpression = expression;
        Objects.requireNonNull(coreExpression);
        CoreExpression coreExpression2 = coreExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MatchExpression.class, CombinedExpression.class}, (Object)coreExpression2, n)) {
            case 0: {
                MatchExpression match = (MatchExpression)coreExpression2;
                return CoreExpressionStats.checkSimpleConditionStraightMatch(match, dataBinding, ctx);
            }
            case 1: {
                CombinedExpression cmb = (CombinedExpression)coreExpression2;
                return cmb.members().stream().allMatch(e -> CoreExpressionStats.checkSimpleSingleTableCondition(e, dataBinding, ctx));
            }
        }
        return true;
    }

    private static boolean checkSimpleConditionStraightMatch(MatchExpression match, DataBinding dataBinding, ProcessContext ctx) {
        return match.operator() != MatchOperator.IS_UNKNOWN || dataBinding.dataTableConfig().lookupTableMetaInfo(match.argName(), ctx).tableNature().containsAllIds() || dataBinding.dataTableConfig().numberOfTables() == 1;
    }

    private static void collectArgNamesMultiRowOrSparse(CoreExpression expression, DataBinding dataBinding, ProcessContext ctx, Set<String> multiRowArgNames) {
        expression.allArgNames().stream().filter(argName -> dataBinding.dataTableConfig().lookupColumn((String)argName, ctx).isMultiRow() || dataBinding.dataTableConfig().lookupTableMetaInfo((String)argName, ctx).tableNature().isSparse()).forEach(multiRowArgNames::add);
    }

    private static void collectArgNamesWithDirectMultiRowSensitivity(CoreExpression expression, Set<String> multiRowArgNames, Set<String> multiRowSensitiveArgNames) {
        CoreExpression coreExpression = expression;
        Objects.requireNonNull(coreExpression);
        CoreExpression coreExpression2 = coreExpression;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CombinedExpression.class, MatchExpression.class, MatchExpression.class, NegationExpression.class}, (Object)coreExpression2, n)) {
                case 0: {
                    CombinedExpression cmb = (CombinedExpression)coreExpression2;
                    cmb.members().forEach(e -> CoreExpressionStats.collectArgNamesWithDirectMultiRowSensitivity(e, multiRowArgNames, multiRowSensitiveArgNames));
                    break block6;
                }
                case 1: {
                    MatchExpression match = (MatchExpression)coreExpression2;
                    if (match.operator() != MatchOperator.IS_UNKNOWN || !multiRowArgNames.contains(match.argName())) {
                        n = 2;
                        continue block6;
                    }
                    multiRowSensitiveArgNames.add(match.argName());
                    break block6;
                }
                case 2: {
                    MatchExpression match = (MatchExpression)coreExpression2;
                    if (match.referencedArgName() == null) {
                        n = 3;
                        continue block6;
                    }
                    if (multiRowArgNames.contains(match.argName())) {
                        multiRowSensitiveArgNames.add(match.argName());
                    }
                    if (!multiRowArgNames.contains(match.referencedArgName())) break block6;
                    multiRowSensitiveArgNames.add(match.referencedArgName());
                    break block6;
                }
                case 3: {
                    NegationExpression neg = (NegationExpression)coreExpression2;
                    if (multiRowArgNames.contains(neg.argName())) {
                        multiRowSensitiveArgNames.add(neg.argName());
                    }
                    if (neg.referencedArgName() == null || !multiRowArgNames.contains(neg.referencedArgName())) break block6;
                    multiRowSensitiveArgNames.add(neg.referencedArgName());
                    break block6;
                }
            }
            break;
        }
    }

    private static void collectArgNamesWithIsNullMultiRowSensitivity(DataBinding dataBinding, ProcessContext ctx, Set<String> argNamesInPositiveIsUnknownMatches, Set<String> multiRowSensitiveArgNames) {
        for (String argName : argNamesInPositiveIsUnknownMatches) {
            if (multiRowSensitiveArgNames.contains(argName) || dataBinding.dataTableConfig().lookupAssignment(argName, ctx).column().filters().isEmpty()) continue;
            multiRowSensitiveArgNames.add(argName);
        }
    }

    private static void collectArgNamesWithMultiRowSensitivity(CoreExpression expression, DataBinding dataBinding, ProcessContext ctx, Set<String> multiRowArgNames, Set<String> multiRowSensitiveArgNames) {
        int sizeBefore = 0;
        do {
            sizeBefore = multiRowSensitiveArgNames.size();
            CoreExpressionStats.collectArgNamesWithDirectMultiRowSensitivity(expression, multiRowArgNames, multiRowSensitiveArgNames);
            CoreExpressionStats.collectArgNamesMultiRowSensitive(expression, dataBinding, ctx, multiRowArgNames, multiRowSensitiveArgNames);
        } while (multiRowSensitiveArgNames.size() > sizeBefore);
    }

    private static void collectArgNamesMultiRowSensitive(CoreExpression expression, DataBinding dataBinding, ProcessContext ctx, Set<String> multiRowArgNames, Set<String> multiRowSensitiveArgNames) {
        List candidates = ParentAwareExpressionNode.collectLeafNodes((CoreExpression)expression);
        for (int idxLeft = 0; idxLeft < candidates.size() - 1; ++idxLeft) {
            ParentAwareExpressionNode leftNode = (ParentAwareExpressionNode)candidates.get(idxLeft);
            for (int idxRight = idxLeft + 1; idxRight < candidates.size(); ++idxRight) {
                SimpleExpression right;
                CoreExpression coreExpression;
                ParentAwareExpressionNode rightNode = (ParentAwareExpressionNode)candidates.get(idxRight);
                if (!leftNode.hasCommonAndParentWith(rightNode) || !((coreExpression = leftNode.expression()) instanceof SimpleExpression)) continue;
                SimpleExpression left = (SimpleExpression)coreExpression;
                coreExpression = rightNode.expression();
                if (!(coreExpression instanceof SimpleExpression) || (right = (SimpleExpression)coreExpression).equals((Object)left) || CoreExpressionStats.isAlreadyMarkedMultiRowSensitive(left, right, multiRowSensitiveArgNames) || !CoreExpressionStats.isTableOverlap(left, right, dataBinding, ctx)) continue;
                CoreExpressionStats.collectArgNamesMultiRowDueToImplication(left, right, multiRowArgNames, multiRowSensitiveArgNames);
            }
        }
    }

    private static boolean isTableOverlap(SimpleExpression left, SimpleExpression right, DataBinding dataBinding, ProcessContext ctx) {
        String tableLeft = dataBinding.dataTableConfig().lookupTableMetaInfo(left.argName(), ctx).tableName();
        String tableRight = dataBinding.dataTableConfig().lookupTableMetaInfo(right.argName(), ctx).tableName();
        String referencedTableLeft = left.referencedArgName() == null ? null : dataBinding.dataTableConfig().lookupTableMetaInfo(left.referencedArgName(), ctx).tableName();
        String referencedTableRight = right.referencedArgName() == null ? null : dataBinding.dataTableConfig().lookupTableMetaInfo(right.referencedArgName(), ctx).tableName();
        return tableLeft.equals(tableRight) || tableLeft.equals(referencedTableRight) || tableRight.equals(referencedTableLeft) || referencedTableLeft != null && referencedTableLeft.equals(referencedTableRight);
    }

    private static boolean isAlreadyMarkedMultiRowSensitive(SimpleExpression left, SimpleExpression right, Set<String> multiRowSensitiveArgNames) {
        return !(!multiRowSensitiveArgNames.contains(left.argName()) || !multiRowSensitiveArgNames.contains(right.argName()) || left.referencedArgName() != null && !multiRowSensitiveArgNames.contains(left.argName()) || right.referencedArgName() != null && !multiRowSensitiveArgNames.contains(right.argName()));
    }

    private static void collectArgNamesMultiRowDueToImplication(SimpleExpression left, SimpleExpression right, Set<String> multiRowArgNames, Set<String> multiRowSensitiveArgNames) {
        if (multiRowArgNames.contains(left.argName())) {
            multiRowSensitiveArgNames.add(left.argName());
        }
        if (left.referencedArgName() != null && multiRowArgNames.contains(left.referencedArgName())) {
            multiRowSensitiveArgNames.add(left.referencedArgName());
        }
        if (multiRowArgNames.contains(right.argName())) {
            multiRowSensitiveArgNames.add(right.argName());
        }
        if (right.referencedArgName() != null && multiRowArgNames.contains(right.referencedArgName())) {
            multiRowSensitiveArgNames.add(right.referencedArgName());
        }
    }

    private static void collectArgNamesInValueMatches(CoreExpression expression, Predicate<SimpleExpression> filter, boolean negated, Set<String> result) {
        CoreExpression coreExpression = expression;
        Objects.requireNonNull(coreExpression);
        CoreExpression coreExpression2 = coreExpression;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MatchExpression.class, NegationExpression.class, CombinedExpression.class}, (Object)coreExpression2, n)) {
                case 0: {
                    MatchExpression match = (MatchExpression)coreExpression2;
                    if (!filter.test((SimpleExpression)match) || negated) {
                        n = 1;
                        continue block5;
                    }
                    result.add(match.argName());
                    break block5;
                }
                case 1: {
                    NegationExpression neg = (NegationExpression)coreExpression2;
                    if (!filter.test((SimpleExpression)neg) || !negated) {
                        n = 2;
                        continue block5;
                    }
                    result.add(neg.argName());
                    break block5;
                }
                case 2: {
                    CombinedExpression cmb = (CombinedExpression)coreExpression2;
                    cmb.childExpressions().stream().forEach(e -> CoreExpressionStats.collectArgNamesInValueMatches(e, filter, negated, result));
                    break block5;
                }
            }
            break;
        }
    }

    private static boolean checkSeparateBaseTableRequired(CoreExpression expression, DataBinding dataBinding, ProcessContext ctx) {
        return dataBinding.dataTableConfig().numberOfTables() > 1 && expression.allArgNames().stream().map(argName -> dataBinding.dataTableConfig().lookupTableMetaInfo((String)argName, ctx)).noneMatch(info -> info.tableNature().containsAllIds()) && !expression.collectExpressions(e -> {
            MatchExpression match;
            return e instanceof MatchExpression && (match = (MatchExpression)e).operator() == MatchOperator.IS_UNKNOWN;
        }).isEmpty();
    }
}

