/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CombinedExpressionType;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.ConversionException;
import de.calamanari.adl.Flag;
import de.calamanari.adl.FormatStyle;
import de.calamanari.adl.FormatUtils;
import de.calamanari.adl.SpecialSetType;
import de.calamanari.adl.TimeOut;
import de.calamanari.adl.cnv.AbstractCoreExpressionConverter;
import de.calamanari.adl.cnv.IsUnknownRemovalConverter;
import de.calamanari.adl.cnv.tps.AdlType;
import de.calamanari.adl.cnv.tps.ArgMetaInfoLookup;
import de.calamanari.adl.irl.CombinedExpression;
import de.calamanari.adl.irl.CoreExpression;
import de.calamanari.adl.irl.MatchExpression;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.irl.NegationExpression;
import de.calamanari.adl.irl.SimpleExpression;
import de.calamanari.adl.irl.SpecialSetExpression;
import de.calamanari.adl.sql.QueryParameter;
import de.calamanari.adl.sql.QueryTemplateWithParameters;
import de.calamanari.adl.sql.QueryType;
import de.calamanari.adl.sql.SqlFormatUtils;
import de.calamanari.adl.sql.cnv.AliasHelper;
import de.calamanari.adl.sql.cnv.ColumnCondition;
import de.calamanari.adl.sql.cnv.ColumnConditionType;
import de.calamanari.adl.sql.cnv.ConversionHint;
import de.calamanari.adl.sql.cnv.CoreExpressionSqlHelper;
import de.calamanari.adl.sql.cnv.CoreExpressionStats;
import de.calamanari.adl.sql.cnv.DefaultMatchConditionFactory;
import de.calamanari.adl.sql.cnv.ExpressionAlias;
import de.calamanari.adl.sql.cnv.MatchCondition;
import de.calamanari.adl.sql.cnv.MatchConditionFactory;
import de.calamanari.adl.sql.cnv.ResettableScpContext;
import de.calamanari.adl.sql.cnv.SqlAugmentationListener;
import de.calamanari.adl.sql.cnv.SqlConversionContext;
import de.calamanari.adl.sql.cnv.SqlConversionProcessContext;
import de.calamanari.adl.sql.config.DataBinding;
import de.calamanari.adl.sql.config.TableMetaInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlExpressionConverter<C extends SqlConversionContext>
extends AbstractCoreExpressionConverter<QueryTemplateWithParameters, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSqlExpressionConverter.class);
    private final ResettableScpContext processContext;

    private static void registerProcessContextProvider(AbstractSqlExpressionConverter<?> converter, ResettableScpContext processContext) {
        converter.setContextPreparator(localContext -> {
            localContext.setProcessContext(processContext);
            return localContext;
        });
    }

    protected AbstractSqlExpressionConverter(Supplier<? extends C> contextSupplier, ResettableScpContext processContext) {
        super(contextSupplier);
        this.processContext = processContext;
        AbstractSqlExpressionConverter.registerProcessContextProvider(this, processContext);
    }

    protected AbstractSqlExpressionConverter(Supplier<? extends C> contextSupplier, DataBinding dataBinding, Map<String, Serializable> globalVariables, Set<Flag> flags) {
        super(contextSupplier);
        this.processContext = new ResettableScpContext(dataBinding, globalVariables, flags);
        AbstractSqlExpressionConverter.registerProcessContextProvider(this, this.processContext);
    }

    protected AbstractSqlExpressionConverter(Supplier<? extends C> contextSupplier, DataBinding dataBinding) {
        this(contextSupplier, dataBinding, null, null);
    }

    public SqlAugmentationListener getAugmentationListener() {
        return ((ResettableScpContext)this.getProcessContext()).getAugmentationListener();
    }

    public void setAugmentationListener(SqlAugmentationListener augmentationListener) {
        ((ResettableScpContext)this.getProcessContext()).setAugmentationListener(augmentationListener == null ? SqlAugmentationListener.none() : augmentationListener);
    }

    public final SqlConversionProcessContext getProcessContext() {
        return this.processContext;
    }

    public void init() {
        super.init();
        ((ResettableScpContext)this.getProcessContext()).reset();
    }

    public final String getIdColumnName() {
        return this.getProcessContext().getIdColumnName();
    }

    public final void setIdColumnName(String idColumnName) {
        ((ResettableScpContext)this.getProcessContext()).setIdColumnName(idColumnName);
    }

    public final QueryType getQueryType() {
        return this.getProcessContext().getQueryType();
    }

    public final void setQueryType(QueryType queryType) {
        ((ResettableScpContext)this.getProcessContext()).setQueryType(queryType);
    }

    public final Map<String, Serializable> getInitialVariables() {
        return ((ResettableScpContext)this.getProcessContext()).getGlobalVariablesTemplate();
    }

    public final Set<Flag> getInitialFlags() {
        return ((ResettableScpContext)this.getProcessContext()).getGlobalFlagsTemplate();
    }

    public final TableMetaInfo getMainTable() {
        return this.getProcessContext().getMainTable();
    }

    protected final void setMainTable(TableMetaInfo mainTable) {
        ((ResettableScpContext)this.getProcessContext()).setMainTable(mainTable);
    }

    public final FormatStyle getStyle() {
        return this.getProcessContext().getStyle();
    }

    public final void setStyle(FormatStyle style) {
        ((ResettableScpContext)this.getProcessContext()).setStyle(style);
    }

    protected final CoreExpressionStats stats() {
        return ((ResettableScpContext)this.getProcessContext()).getExpressionHelper().getStats();
    }

    protected final AliasHelper aliasHelper() {
        return this.getProcessContext().getAliasHelper();
    }

    protected final CoreExpressionSqlHelper expressionHelper() {
        return this.getProcessContext().getExpressionHelper();
    }

    protected final DataBinding dataBinding() {
        return this.getProcessContext().getDataBinding();
    }

    protected final StringBuilder whereClause() {
        return this.getProcessContext().getWhereClause();
    }

    protected final MatchConditionFactory conditionFactory() {
        return this.getProcessContext().getConditionFactory();
    }

    protected final FormatStyle style() {
        return this.getProcessContext().getStyle();
    }

    protected final Set<Flag> flags() {
        return this.getProcessContext().getGlobalFlags();
    }

    protected final Map<String, Serializable> globalVariables() {
        return this.getProcessContext().getGlobalVariables();
    }

    protected final Set<TableMetaInfo> tablesInWhereClause() {
        return this.getProcessContext().getTablesInWhereClause();
    }

    protected final Set<ExpressionAlias> aliasesInWhereClause() {
        return this.getProcessContext().getAliasesInWhereClause();
    }

    protected final SqlAugmentationListener augmentationListener() {
        return this.getAugmentationListener();
    }

    protected final String getMainIdColumnName() {
        return this.getProcessContext().getMainIdColumnName();
    }

    protected CoreExpression prepareRootExpression() {
        IsUnknownRemovalConverter irc;
        CoreExpression rootExpression = (CoreExpression)this.getRootExpression();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Preparing \n{}", (Object)rootExpression.format(FormatStyle.PRETTY_PRINT));
        }
        if ((rootExpression = (irc = new IsUnknownRemovalConverter((ArgMetaInfoLookup)this.dataBinding().dataTableConfig())).convert(rootExpression)) instanceof SpecialSetExpression) {
            SpecialSetExpression spc = (SpecialSetExpression)rootExpression;
            if (spc.setType() == SpecialSetType.ALL) {
                String msg = "Unable to convert the given expression because it implies <%s>.\nThis late error can happen if the expression uses IS UNKNOWN on a field that is marked as always known.\nIn this case an expression can \"collapse\" to <ALL>, for example \"arg1 = 2 OR arg3 IS NOT UNKNOWN\" with arg3 always known.\nFor details, check the expression and the mapped physical data model.\nIt is recommended to report this error to the user as an \"unintentional full audience match\" with the advice to rework the condition.\n\ngiven expression:\n%s\n";
                throw new ConversionException(String.format(msg, spc.setType(), ((CoreExpression)this.getRootExpression()).format(FormatStyle.PRETTY_PRINT)), AudlangMessage.msg((AudlangUserMessage)CommonErrors.ERR_1001_ALWAYS_TRUE, (Object[])new Object[0]));
            }
            String msg = "Unable to convert the given expression because it implies <%s>.\nThis late error can happen if the expression uses IS UNKNOWN on a field that is marked as always known.\nIn this case an expression can \"collapse\" to <NONE>, for example \"arg1 = 2 OR arg3 IS UNKNOWN\" with arg3 always known.\nFor details, check the expression and the mapped physical data model.\nIt is recommended to gracefully ignore this exception and return an empty result.\n\ngiven expression:\n%s\n";
            throw new ConversionException(String.format(msg, spc.setType(), ((CoreExpression)this.getRootExpression()).format(FormatStyle.PRETTY_PRINT)), AudlangMessage.msg((AudlangUserMessage)CommonErrors.ERR_1002_ALWAYS_FALSE, (Object[])new Object[0]));
        }
        ((ResettableScpContext)this.getProcessContext()).setExpressionHelper(this.createCoreExpressionSqlHelper(rootExpression));
        ((ResettableScpContext)this.getProcessContext()).setAliasHelper(this.createAliasHelper());
        ((ResettableScpContext)this.getProcessContext()).setConditionFactory(this.createMatchConditionFactory());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Preparation complete: \n{} \nflags={}", (Object)rootExpression, (Object)this.getProcessContext().getGlobalFlags());
        }
        return rootExpression;
    }

    protected AliasHelper createAliasHelper() {
        return new AliasHelper();
    }

    protected CoreExpressionSqlHelper createCoreExpressionSqlHelper(CoreExpression rootExpression) {
        return new CoreExpressionSqlHelper(rootExpression, TimeOut.createDefaultTimeOut((String)((Object)((Object)this)).getClass().getSimpleName()), this.dataBinding(), this.getProcessContext());
    }

    protected MatchConditionFactory createMatchConditionFactory() {
        return new DefaultMatchConditionFactory(this.getProcessContext());
    }

    public void enterCombinedExpression(CombinedExpression expression) {
        ((SqlConversionContext)this.getContext()).setCombiType(expression.combiType());
        ArrayList<List<SimpleExpression>> groups = new ArrayList<List<SimpleExpression>>();
        ArrayList<CoreExpression> remainder = new ArrayList<CoreExpression>();
        this.appendCombinerIfRequired(this.whereClause(), ((SqlConversionContext)this.getParentContext()).getCombiType().name());
        this.expressionHelper().groupInClauses(expression, groups, remainder);
        if (groups.size() + remainder.size() > 1) {
            FormatUtils.appendSpaced((StringBuilder)this.whereClause(), (String[])new String[]{"("});
        } else {
            ((SqlConversionContext)this.getContext()).suppressClosingBrace();
        }
        int lastLen = this.whereClause().length();
        expression.members().stream().filter(Predicate.not(remainder::contains)).forEach(((SqlConversionContext)this.getContext())::skipChildExpression);
        for (int idx = 0; idx < groups.size(); ++idx) {
            if (this.whereClause().length() > lastLen) {
                FormatUtils.appendIndentOrWhitespace((StringBuilder)this.whereClause(), (FormatStyle)this.style(), (int)(this.getNormalizedDepth() + 1), (boolean)true);
                this.whereClause().append(expression.combiType() == CombinedExpressionType.AND ? "AND" : "OR");
                FormatUtils.space((StringBuilder)this.whereClause());
                lastLen = this.whereClause().length();
            }
            List group = (List)groups.get(idx);
            ExpressionAlias alias = this.aliasHelper().getOrCreateAlias(CombinedExpression.of(new ArrayList(group), (CombinedExpressionType)expression.combiType()));
            if (expression.combiType() == CombinedExpressionType.OR) {
                alias.registerPositiveReference();
            } else {
                alias.registerNegativeReference();
            }
            MatchCondition condition = this.conditionFactory().createInClauseCondition(group);
            this.appendToGlobalWhereClause(this.whereClause(), condition, alias);
        }
    }

    public void exitCombinedExpression(CombinedExpression expression) {
        if (!((SqlConversionContext)this.getContext()).isClosingBraceSuppressed()) {
            FormatUtils.appendIndentOrWhitespace((StringBuilder)this.whereClause(), (FormatStyle)this.style(), (int)(this.getNormalizedDepth() + 1), (boolean)true);
            FormatUtils.appendSpaced((StringBuilder)this.whereClause(), (String[])new String[]{")"});
        }
    }

    public void handleMatchExpression(MatchExpression expression) {
        if (!((SqlConversionContext)this.getParentContext()).isSkipped((CoreExpression)expression)) {
            this.handleSimpleExpressionInternal((SimpleExpression)expression);
        }
    }

    public void enterNegationExpression(NegationExpression expression) {
        if (!((SqlConversionContext)this.getParentContext()).isSkipped((CoreExpression)expression)) {
            this.handleSimpleExpressionInternal((SimpleExpression)expression);
        }
        ((SqlConversionContext)this.getContext()).skipChildExpression((CoreExpression)expression.delegate());
    }

    public void handleSpecialSetExpression(SpecialSetExpression expression) {
        if (expression.setType() == SpecialSetType.ALL) {
            throw new ConversionException("Cannot convert <ALL> to SQL.", AudlangMessage.msg((AudlangUserMessage)CommonErrors.ERR_1001_ALWAYS_TRUE, (Object[])new Object[0]));
        }
        if (expression.setType() == SpecialSetType.NONE) {
            throw new ConversionException("Cannot convert <NONE> to SQL.", AudlangMessage.msg((AudlangUserMessage)CommonErrors.ERR_1002_ALWAYS_FALSE, (Object[])new Object[0]));
        }
    }

    private void handleSimpleExpressionInternal(SimpleExpression expression) {
        ExpressionAlias alias = this.aliasHelper().getOrCreateAlias((CoreExpression)expression);
        if (expression instanceof MatchExpression) {
            alias.registerPositiveReference();
        } else {
            alias.registerNegativeReference();
        }
        MatchCondition condition = this.conditionFactory().createSimpleCondition(expression);
        this.appendCombinerIfRequired(this.whereClause(), ((SqlConversionContext)this.getParentContext()).getCombiType().name());
        this.appendToGlobalWhereClause(this.whereClause(), condition, alias);
    }

    private void appendCombinerIfRequired(StringBuilder sb, String combiner) {
        if (!SqlFormatUtils.endsWithOpenBraceOrAllWhitespace(sb)) {
            FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)this.getNormalizedDepth(), (boolean)true);
            sb.append(combiner);
            FormatUtils.space((StringBuilder)sb);
        }
    }

    protected void appendAliasUnionBaseQuery(StringBuilder sb, List<ExpressionAlias> aliases) {
        sb.append(this.aliasHelper().getStartSelectionName());
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"AS", "("});
        List<List<ExpressionAlias>> aliasGroups = this.aliasHelper().groupAliasesByTable(this.conditionFactory(), aliases);
        for (int idx = 0; idx < aliasGroups.size(); ++idx) {
            List<ExpressionAlias> aliasGroup = aliasGroups.get(idx);
            if (idx != 0) {
                FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)(this.getNormalizedDepth() + 2), (boolean)true);
                sb.append("UNION");
            }
            this.appendAliasGroupToBaseQuery(sb, aliasGroup);
        }
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
    }

    protected void appendAllTableUnionBaseQuery(StringBuilder sb) {
        sb.append(this.aliasHelper().getStartSelectionName());
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"AS", "("});
        List<TableMetaInfo> allTables = this.dataBinding().dataTableConfig().allTableMetaInfos();
        for (int idx = 0; idx < allTables.size(); ++idx) {
            if (idx != 0) {
                FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)(this.getNormalizedDepth() + 2), (boolean)true);
                FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"UNION"});
            }
            this.appendFullTableQuery(sb, allTables.get(idx));
        }
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
    }

    protected void appendFullTableQuery(StringBuilder sb, TableMetaInfo table) {
        boolean idColumnRenamingRequired = !table.idColumnName().equals(this.getIdColumnName());
        sb.append("SELECT");
        this.augmentationListener().handleAfterWithSelect(sb, this.getProcessContext(), table.tableName());
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{table.idColumnName()});
        SqlFormatUtils.appendSpacedIf(sb, idColumnRenamingRequired, "AS", this.getIdColumnName());
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"FROM"});
        sb.append(table.tableName());
        if (!table.tableFilters().isEmpty()) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"WHERE"});
            List<ColumnCondition> tableFilterConditions = table.tableFilters().stream().map(filterColumn -> MatchCondition.createFilterColumnCondition(ColumnConditionType.FILTER_LEFT, filterColumn, this.getProcessContext())).toList();
            this.appendFilterColumnConditions(sb, table.tableName(), tableFilterConditions, false);
        }
    }

    protected void appendAliasGroupToBaseQuery(StringBuilder sb, List<ExpressionAlias> aliasGroup) {
        MatchCondition condition = this.conditionFactory().createMatchCondition(aliasGroup.get(0).getExpression());
        boolean qualifiedTableNameRequired = condition.isDualTableReferenceMatch() || condition.isSingleTableReferenceMatchInvolvingMultipleRows();
        boolean idColumnRenamingRequired = !condition.idColumnNameLeft(false).equals(this.getIdColumnName());
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"SELECT"});
        if (condition.isReferenceMatch()) {
            this.augmentationListener().handleAfterWithSelect(sb, this.getProcessContext(), condition.tableLeft().tableName(), condition.tableRight().tableName());
        } else {
            this.augmentationListener().handleAfterWithSelect(sb, this.getProcessContext(), condition.tableLeft().tableName());
        }
        sb.append(condition.idColumnNameLeft(qualifiedTableNameRequired));
        SqlFormatUtils.appendSpacedIf(sb, idColumnRenamingRequired, "AS", this.getIdColumnName());
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"FROM"});
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{condition.tableLeft().tableName()});
        this.appendInnerJoinForReferenceMatchIfRequired(sb, condition);
        List<CoreExpression> aliasExpressions = this.expressionHelper().consolidateAliasGroupExpressions(aliasGroup.stream().map(ExpressionAlias::getExpression).toList());
        for (int idx = 0; idx < aliasExpressions.size(); ++idx) {
            CoreExpression aliasExpression = aliasExpressions.get(idx);
            if (idx == 0) {
                FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"WHERE"});
            } else {
                FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"OR"});
            }
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"("});
            this.appendMatchCondition(sb, this.conditionFactory().createMatchCondition(aliasExpression), qualifiedTableNameRequired);
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
        }
    }

    protected void appendAliasQuery(StringBuilder sb, ExpressionAlias alias) {
        if (alias.isReferenceMatch()) {
            this.appendReferenceMatchAliasQuery(sb, alias);
        } else {
            MatchCondition condition = this.conditionFactory().createMatchCondition(alias.getExpression());
            if (condition.operator() == MatchOperator.IS_UNKNOWN && alias.getNegativeReferenceCount() > 0) {
                condition = MatchCondition.negate(condition);
            }
            boolean idColumnRenamingRequired = !condition.idColumnNameLeft(false).equals(this.getIdColumnName());
            sb.append(alias.getName());
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"AS", "(", "SELECT"});
            this.augmentationListener().handleAfterWithSelect(sb, this.getProcessContext(), condition.tableLeft().tableName());
            SqlFormatUtils.appendSpacedIf(sb, this.stats().isMultiRowSensitive(condition.argNameLeft()), "DISTINCT");
            sb.append(condition.idColumnNameLeft(false));
            SqlFormatUtils.appendSpacedIf(sb, idColumnRenamingRequired, "AS", this.getIdColumnName());
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"FROM"});
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{condition.tableLeft().tableName()});
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"WHERE"});
            this.appendMatchCondition(sb, condition, false);
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
        }
    }

    private void appendReferenceMatchAliasQuery(StringBuilder sb, ExpressionAlias alias) {
        MatchCondition condition = this.conditionFactory().createMatchCondition(alias.getExpression());
        boolean qualifiedTableNameRequired = condition.isDualTableReferenceMatch() || condition.isSingleTableReferenceMatchInvolvingMultipleRows();
        AdlType commonAdlType = this.dataBinding().dataTableConfig().lookup(condition.argNameLeft()).type();
        String columnNameLeft = condition.dataColumnNameLeft(qualifiedTableNameRequired);
        String termLeft = condition.columnLeft().columnType().getNativeTypeCaster().formatNativeTypeCast(condition.argNameLeft(), columnNameLeft, (AdlType)condition.columnLeft().columnType(), commonAdlType);
        Object columnNameRight = condition.dataColumnNameRight(false);
        if (qualifiedTableNameRequired) {
            if (condition.isDualTableReferenceMatch()) {
                columnNameRight = condition.dataColumnNameRight(true);
            } else if (condition.isSingleTableReferenceMatchInvolvingMultipleRows()) {
                columnNameRight = "sq__self." + (String)columnNameRight;
            }
        }
        String termRight = condition.columnRight().columnType().getNativeTypeCaster().formatNativeTypeCast(condition.argNameRight(), (String)columnNameRight, (AdlType)condition.columnRight().columnType(), commonAdlType);
        boolean idColumnRenamingRequired = !condition.idColumnNameLeft(false).equals(this.getIdColumnName());
        sb.append(alias.getName());
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"AS", "(", "SELECT"});
        this.augmentationListener().handleAfterWithSelect(sb, this.getProcessContext(), condition.tableLeft().tableName(), condition.tableRight().tableName());
        SqlFormatUtils.appendSpacedIf(sb, this.stats().isMultiRowSensitive(condition.argNameLeft()), "DISTINCT");
        sb.append(condition.idColumnNameLeft(qualifiedTableNameRequired));
        SqlFormatUtils.appendSpacedIf(sb, idColumnRenamingRequired, "AS", this.getIdColumnName());
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"FROM"});
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{condition.tableLeft().tableName()});
        this.appendInnerJoinForReferenceMatchIfRequired(sb, condition);
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"WHERE"});
        boolean filtersPresent = condition.hasAnyFilterColumnConditions();
        if (filtersPresent) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"("});
        }
        this.appendMainCondition(sb, condition, termLeft, termRight);
        if (filtersPresent) {
            this.appendFilterColumnConditions(sb, condition, true);
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
        }
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
    }

    private boolean appendInnerJoinForReferenceMatchIfRequired(StringBuilder sb, MatchCondition condition) {
        if (condition.isDualTableReferenceMatch() || condition.isSingleTableReferenceMatchInvolvingMultipleRows()) {
            FormatUtils.space((StringBuilder)sb);
            this.augmentationListener().handleAppendJoinType(sb, this.getProcessContext(), condition.tableLeft().tableName(), condition.tableRight().tableName(), "INNER JOIN");
            FormatUtils.space((StringBuilder)sb);
            sb.append(this.aliasHelper().determineReferenceMatchTableRight(condition));
            this.augmentationListener().handleBeforeOnClause(sb, this.getProcessContext(), condition.tableLeft().tableName(), condition.tableRight().tableName());
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"ON"});
            sb.append(condition.idColumnNameLeft(true));
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"="});
            sb.append(this.aliasHelper().determineReferenceMatchIdColumnOrAliasRight(condition));
            if (!condition.tableLeft().tableFilters().isEmpty() || !condition.tableRight().tableFilters().isEmpty()) {
                List<ColumnCondition> tableFilterConditionsLeft = condition.tableLeft().tableFilters().stream().map(filterColumn -> MatchCondition.createFilterColumnCondition(ColumnConditionType.FILTER_LEFT, filterColumn, this.getProcessContext())).toList();
                List<ColumnCondition> tableFilterConditionsRight = condition.tableRight().tableFilters().stream().map(filterColumn -> MatchCondition.createFilterColumnCondition(ColumnConditionType.FILTER_RIGHT, filterColumn, this.getProcessContext())).toList();
                this.appendFilterColumnConditions(sb, condition.tableLeft().tableName(), tableFilterConditionsLeft, true);
                this.appendFilterColumnConditions(sb, this.aliasHelper().determineReferenceMatchTableOrAliasRight(condition), tableFilterConditionsRight, true);
            }
            return true;
        }
        return false;
    }

    protected void appendToAliasConditionClause(StringBuilder sb, MatchCondition condition, boolean qualified) {
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"("});
        this.appendMatchCondition(sb, condition, qualified);
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
    }

    private void appendToGlobalWhereClause(StringBuilder sb, MatchCondition condition, boolean qualified) {
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"("});
        if (condition.operator() == MatchOperator.IS_UNKNOWN && !condition.isNegation() && !this.expressionHelper().isNullQueryingAllowed(condition.argNameLeft())) {
            ExpressionAlias extraAliasLeft = this.aliasHelper().getOrCreateAlias(MatchExpression.isUnknown((String)condition.argNameLeft()));
            extraAliasLeft.registerNegativeReference();
            this.appendAliasExistenceCheckToWhereClause(sb, extraAliasLeft, true);
        } else {
            this.appendMatchCondition(sb, condition, qualified);
            this.tablesInWhereClause().add(condition.tableLeft());
            if (condition.isDualTableReferenceMatch()) {
                this.tablesInWhereClause().add(condition.tableRight());
            }
        }
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
    }

    protected void appendToGlobalWhereClause(StringBuilder sb, MatchCondition condition, ExpressionAlias currentAlias) {
        if (ConversionHint.NO_JOINS_REQUIRED.check(this.getProcessContext().getGlobalFlags())) {
            this.appendToGlobalWhereClause(sb, condition, false);
        } else if (this.expressionHelper().isMultiRowSensitiveMatch(condition)) {
            this.appendAliasExistenceCheckWithExtraNullCheckIfRequired(sb, condition, currentAlias);
        } else {
            this.appendToGlobalWhereClause(sb, condition, true);
        }
    }

    protected void appendMatchCondition(StringBuilder sb, MatchCondition condition, boolean qualified) {
        boolean hasFilters;
        AdlType commonAdlType = this.dataBinding().dataTableConfig().lookup(condition.argNameLeft()).type();
        String columnNameLeft = condition.dataColumnNameLeft(qualified);
        String termLeft = condition.columnLeft().columnType().getNativeTypeCaster().formatNativeTypeCast(condition.argNameLeft(), columnNameLeft, (AdlType)condition.columnLeft().columnType(), commonAdlType);
        String termRight = null;
        if (condition.isReferenceMatch()) {
            String columnNameRight = this.aliasHelper().determineReferenceMatchDataColumnOrAliasRight(condition, qualified);
            termRight = condition.columnRight().columnType().getNativeTypeCaster().formatNativeTypeCast(condition.argNameRight(), columnNameRight, (AdlType)condition.columnRight().columnType(), commonAdlType);
        }
        if (hasFilters = condition.hasAnyFilterColumnConditions()) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"("});
        }
        if (condition.operator() == MatchOperator.IS_UNKNOWN && !condition.isNegation() && this.expressionHelper().isNullQueryingAllowed(condition.argNameLeft())) {
            sb.append(termLeft);
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"IS NULL"});
        } else if (condition.operator() == MatchOperator.IS_UNKNOWN) {
            sb.append(termLeft);
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"IS NOT NULL"});
        } else {
            this.appendMainCondition(sb, condition, termLeft, termRight);
        }
        if (hasFilters) {
            this.appendFilterColumnConditions(sb, condition, qualified);
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
        }
    }

    protected void appendAliasExistenceCheckWithExtraNullCheckIfRequired(StringBuilder sb, MatchCondition condition, ExpressionAlias alias) {
        MatchExpression match;
        boolean extraCheckRequired = this.expressionHelper().isExtraExistenceMatchRequired(condition);
        if (extraCheckRequired) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"("});
            this.appendExtraAliasNullCheck(sb, condition);
        }
        boolean negate = condition.isNegation();
        CoreExpression coreExpression = alias.getExpression();
        if (coreExpression instanceof MatchExpression && (match = (MatchExpression)coreExpression).operator() == MatchOperator.IS_UNKNOWN) {
            negate = !negate;
        }
        this.appendAliasExistenceCheckToWhereClause(sb, alias, negate);
        if (extraCheckRequired) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
        }
    }

    private void appendExtraAliasNullCheck(StringBuilder sb, MatchCondition condition) {
        ExpressionAlias extraAliasLeft = this.aliasHelper().getOrCreateAlias(MatchExpression.isUnknown((String)condition.argNameLeft()));
        extraAliasLeft.registerNegativeReference();
        this.appendAliasExistenceCheckToWhereClause(sb, extraAliasLeft, false);
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"AND"});
        if (condition.isReferenceMatch()) {
            ExpressionAlias extraAliasRight = this.aliasHelper().getOrCreateAlias(MatchExpression.isUnknown((String)condition.argNameRight()));
            extraAliasRight.registerNegativeReference();
            this.appendAliasExistenceCheckToWhereClause(sb, extraAliasRight, false);
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"AND"});
        }
    }

    private void appendAliasExistenceCheckToWhereClause(StringBuilder sb, ExpressionAlias extraAlias, boolean negate) {
        SqlFormatUtils.appendQualifiedColumnName(sb, extraAlias.getName(), this.getIdColumnName());
        SqlFormatUtils.appendIsNullInversion(sb, negate);
        this.aliasesInWhereClause().add(extraAlias);
    }

    private void appendMainCondition(StringBuilder sb, MatchCondition condition, String termLeft, String termRight) {
        if (condition.isNegation() && condition.operator() != MatchOperator.IS_UNKNOWN && condition.operator() != MatchOperator.EQUALS && condition.type() != ColumnConditionType.IN_CLAUSE) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"NOT"});
        }
        switch (condition.type()) {
            case REFERENCE: {
                this.appendReferenceMatchCondition(sb, condition, termLeft, termRight);
                break;
            }
            case SINGLE: 
            case FILTER_LEFT: 
            case FILTER_RIGHT: {
                this.appendValueMatchCondition(sb, condition, termLeft);
                break;
            }
            case IN_CLAUSE: {
                this.appendInClauseMatchCondition(sb, condition, termLeft);
                break;
            }
            case AFTER_TODAY: {
                this.appendAfterTodayMatchCondition(sb, condition, termLeft);
                break;
            }
            case DATE_RANGE: {
                this.appendDateRangeMatchCondition(sb, condition, termLeft);
                break;
            }
            default: {
                throw new IllegalStateException("Not yet implemented: " + String.valueOf(condition));
            }
        }
    }

    private void appendInClauseMatchCondition(StringBuilder sb, MatchCondition condition, String termLeft) {
        sb.append(termLeft);
        if (condition.isNegation()) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"NOT"});
        }
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"IN"});
        List<QueryParameter> parameters = condition.getPrimaryColumnCondition().parameters();
        sb.append(parameters.stream().map(QueryParameter::createReference).collect(Collectors.joining(", ", "(", ")")));
    }

    private void appendAfterTodayMatchCondition(StringBuilder sb, MatchCondition condition, String termLeft) {
        sb.append(termLeft);
        FormatUtils.space((StringBuilder)sb);
        sb.append(">");
        sb.append("=");
        FormatUtils.space((StringBuilder)sb);
        sb.append(condition.getPrimaryColumnCondition().parameters().get(0).createReference());
    }

    private void appendDateRangeMatchCondition(StringBuilder sb, MatchCondition condition, String termLeft) {
        if (condition.isNegation()) {
            sb.append("(");
            sb.append(termLeft);
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"<"});
            sb.append(condition.getPrimaryColumnCondition().parameters().get(0).createReference());
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"OR"});
            sb.append(termLeft);
            FormatUtils.space((StringBuilder)sb);
            sb.append(">");
            sb.append("=");
            FormatUtils.space((StringBuilder)sb);
            sb.append(condition.getPrimaryColumnCondition().parameters().get(1).createReference());
            sb.append(")");
        } else {
            sb.append("(");
            sb.append(termLeft);
            FormatUtils.space((StringBuilder)sb);
            sb.append(">");
            sb.append("=");
            FormatUtils.space((StringBuilder)sb);
            sb.append(condition.getPrimaryColumnCondition().parameters().get(0).createReference());
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"AND"});
            sb.append(termLeft);
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"<"});
            sb.append(condition.getPrimaryColumnCondition().parameters().get(1).createReference());
            sb.append(")");
        }
    }

    private void appendValueMatchCondition(StringBuilder sb, MatchCondition condition, String termLeft) {
        switch (condition.operator()) {
            case EQUALS: {
                this.appendEqualsValueMatchCondition(sb, condition, termLeft);
                break;
            }
            case CONTAINS: {
                this.appendContainsMatchCondition(sb, condition, termLeft);
                break;
            }
            case IS_UNKNOWN: {
                this.appendIsNullMatchCondition(sb, condition, termLeft);
                break;
            }
            case GREATER_THAN: 
            case LESS_THAN: {
                this.appendLessThanGreaterThanMatchCondition(sb, condition, termLeft);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected operator in reference match, given: " + String.valueOf(condition));
            }
        }
    }

    private void appendIsNullMatchCondition(StringBuilder sb, MatchCondition condition, String termLeft) {
        sb.append(termLeft);
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{condition.isNegation() ? "IS NOT NULL" : "IS NULL"});
    }

    private void appendEqualsValueMatchCondition(StringBuilder sb, MatchCondition condition, String termLeft) {
        sb.append(termLeft);
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{condition.isNegation() ? "<>" : "="});
        sb.append(condition.getPrimaryColumnCondition().parameters().get(0).createReference());
    }

    private void appendContainsMatchCondition(StringBuilder sb, MatchCondition condition, String termLeft) {
        sb.append(this.dataBinding().sqlContainsPolicy().createInstruction(termLeft, condition.getPrimaryColumnCondition().parameters().get(0).createReference()));
    }

    private void appendLessThanGreaterThanMatchCondition(StringBuilder sb, MatchCondition condition, String termLeft) {
        sb.append(termLeft);
        switch (condition.operator()) {
            case GREATER_THAN: {
                FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{">"});
                break;
            }
            case LESS_THAN: {
                FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"<"});
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected operator in value match, given: " + String.valueOf(condition));
            }
        }
        sb.append(condition.getPrimaryColumnCondition().parameters().get(0).createReference());
    }

    private void appendReferenceMatchCondition(StringBuilder sb, MatchCondition condition, String termLeft, String termRight) {
        sb.append(termLeft);
        if (condition.isNegation() && condition.operator() == MatchOperator.EQUALS) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"<>"});
        } else {
            switch (condition.operator()) {
                case EQUALS: {
                    FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"="});
                    break;
                }
                case GREATER_THAN: {
                    FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{">"});
                    break;
                }
                case LESS_THAN: {
                    FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"<"});
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected operator in reference match, given: " + String.valueOf(condition));
                }
            }
        }
        sb.append(termRight);
    }

    private void appendLeftFilterColumnConditions(StringBuilder sb, MatchCondition condition, boolean qualified) {
        List<ColumnCondition> leftColumnConditions = condition.getLeftFilterColumnConditions();
        if (!leftColumnConditions.isEmpty()) {
            String optionalTableOrAliasName = qualified ? condition.tableLeft().tableName() : null;
            this.appendFilterColumnConditions(sb, optionalTableOrAliasName, leftColumnConditions, true);
        }
    }

    private void appendRightFilterColumnConditions(StringBuilder sb, MatchCondition condition, boolean qualified) {
        List<ColumnCondition> rightColumnConditions = condition.getRightFilterColumnConditions();
        if (!rightColumnConditions.isEmpty()) {
            String optionalTableOrAliasName = null;
            if (qualified) {
                optionalTableOrAliasName = condition.isSingleTableReferenceMatchInvolvingMultipleRows() ? "sq__self" : condition.tableRight().tableName();
            }
            this.appendFilterColumnConditions(sb, optionalTableOrAliasName, rightColumnConditions, true);
        }
    }

    private void appendFilterColumnConditions(StringBuilder sb, MatchCondition condition, boolean qualified) {
        this.appendLeftFilterColumnConditions(sb, condition, qualified);
        this.appendRightFilterColumnConditions(sb, condition, qualified);
    }

    protected void appendFilterColumnConditions(StringBuilder sb, String optionalTableOrAliasName, List<ColumnCondition> columnConditions, boolean followUp) {
        Object prefix = optionalTableOrAliasName == null ? "" : optionalTableOrAliasName + ".";
        for (int idx = 0; idx < columnConditions.size(); ++idx) {
            ColumnCondition condition = columnConditions.get(idx);
            if (followUp) {
                FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"AND"});
            } else {
                followUp = true;
            }
            sb.append((String)prefix + condition.column().columnName());
            if (condition.operator() == MatchOperator.IS_UNKNOWN) {
                FormatUtils.space((StringBuilder)sb);
                sb.append("IS NULL");
                continue;
            }
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"="});
            sb.append(condition.parameters().get(0).createReference());
        }
    }
}

