/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql;

import de.calamanari.adl.cnv.tps.AdlType;
import de.calamanari.adl.cnv.tps.ArgValueFormatter;
import de.calamanari.adl.cnv.tps.NativeTypeCaster;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.DefaultQueryParameterApplicator;
import de.calamanari.adl.sql.DefaultQueryParameterCreator;
import de.calamanari.adl.sql.DefaultSqlFormatter;
import de.calamanari.adl.sql.QueryParameterApplicator;
import de.calamanari.adl.sql.QueryParameterCreator;

public enum DefaultAdlSqlType implements AdlSqlType
{
    SQL_BIT(-7, DefaultSqlFormatter.SQL_BIT),
    SQL_BIGINT(-5, DefaultSqlFormatter.SQL_BIGINT),
    SQL_BOOLEAN(16, DefaultSqlFormatter.SQL_BOOLEAN),
    SQL_CHAR(1, DefaultSqlFormatter.SQL_CHAR),
    SQL_DATE(91, DefaultSqlFormatter.SQL_DATE_DEFAULT),
    SQL_DECIMAL(3, DefaultSqlFormatter.SQL_DECIMAL),
    SQL_DOUBLE(8, DefaultSqlFormatter.SQL_DOUBLE),
    SQL_FLOAT(6, DefaultSqlFormatter.SQL_FLOAT),
    SQL_INTEGER(4, DefaultSqlFormatter.SQL_INTEGER),
    SQL_LONGNVARCHAR(-16, DefaultSqlFormatter.SQL_LONGNVARCHAR),
    SQL_LONGVARCHAR(-1, DefaultSqlFormatter.SQL_LONGVARCHAR),
    SQL_NCHAR(-15, DefaultSqlFormatter.SQL_NCHAR),
    SQL_NUMERIC(2, DefaultSqlFormatter.SQL_NUMERIC),
    SQL_NVARCHAR(-9, DefaultSqlFormatter.SQL_NVARCHAR),
    SQL_REAL(7, DefaultSqlFormatter.SQL_REAL),
    SQL_SMALLINT(5, DefaultSqlFormatter.SQL_SMALLINT),
    SQL_TIMESTAMP(93, DefaultSqlFormatter.SQL_TIMESTAMP_DEFAULT),
    SQL_TINYINT(-6, DefaultSqlFormatter.SQL_TINYINT),
    SQL_VARCHAR(12, DefaultSqlFormatter.SQL_VARCHAR);

    private final int javaSqlType;
    private final ArgValueFormatter formatter;
    public static final NativeTypeCaster DUMMY_TYPE_CASTER;

    private DefaultAdlSqlType(int javaSqlType, ArgValueFormatter formatter) {
        this.javaSqlType = javaSqlType;
        this.formatter = formatter;
    }

    public ArgValueFormatter getFormatter() {
        return this.formatter;
    }

    public boolean supportsContains() {
        return this == SQL_CHAR || this == SQL_LONGNVARCHAR || this == SQL_LONGVARCHAR || this == SQL_NCHAR || this == SQL_NVARCHAR || this == SQL_VARCHAR;
    }

    public boolean supportsLessThanGreaterThan() {
        return this != SQL_BIT && this != SQL_BOOLEAN;
    }

    @Override
    public int getJavaSqlType() {
        return this.javaSqlType;
    }

    @Override
    public QueryParameterCreator getQueryParameterCreator() {
        return DefaultQueryParameterCreator.getInstance();
    }

    @Override
    public QueryParameterApplicator getQueryParameterApplicator() {
        return DefaultQueryParameterApplicator.getInstance();
    }

    public NativeTypeCaster getNativeTypeCaster() {
        return DUMMY_TYPE_CASTER;
    }

    static {
        DUMMY_TYPE_CASTER = new NativeTypeCaster(){
            private static final long serialVersionUID = -3669047015013254849L;

            public String formatNativeTypeCast(String argName, String nativeFieldName, AdlType argType, AdlType requestedArgType) {
                return nativeFieldName;
            }

            Object readResolve() {
                return DUMMY_TYPE_CASTER;
            }
        };
    }
}

