/*
 * Decompiled with CFR 0.152.
 */
package de.cotto.javaconventions.plugins;

import de.cotto.javaconventions.Utils;
import de.cotto.javaconventions.plugins.TestsPlugin;
import info.solidsoft.gradle.pitest.PitestPlugin;
import info.solidsoft.gradle.pitest.PitestPluginExtension;
import info.solidsoft.gradle.pitest.PitestTask;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;

public abstract class MutationTestsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(PitestPlugin.class);
        project.getPluginManager().apply(TestsPlugin.class);
        PitestPluginExtension pitest = (PitestPluginExtension)project.getExtensions().getByType(PitestPluginExtension.class);
        pitest.getPitestVersion().set((Object)Utils.getVersion(project, "pitest"));
        pitest.getJunit5PluginVersion().set((Object)Utils.getVersion(project, "pitestJunit5Plugin"));
        pitest.getTargetClasses().set(List.of("de.cotto.*"));
        pitest.getOutputFormats().set(List.of("XML", "HTML"));
        pitest.getTimestampedReports().set((Object)false);
        pitest.getFailWhenNoMutations().set((Object)false);
        pitest.getExcludedMethods().set(List.of("hashCode"));
        pitest.getThreads().set((Object)Math.max(Runtime.getRuntime().availableProcessors() / 2, 1));
        pitest.getTestStrengthThreshold().set((Object)100);
        TaskCollection pitestTasks = project.getTasks().withType(PitestTask.class);
        TaskCollection testTasks = project.getTasks().withType(Test.class);
        pitestTasks.forEach(pitestTask -> pitestTask.dependsOn(new Object[]{testTasks}));
    }
}

