/*
 * Decompiled with CFR 0.152.
 */
package de.cotto.javaconventions.plugins;

import com.adarshr.gradle.testlogger.TestLoggerExtension;
import de.cotto.javaconventions.Utils;
import de.cotto.javaconventions.plugins.TestsPlugin;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.testing.base.TestingExtension;

public abstract class IntegrationTestsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(TestsPlugin.class);
        TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
        NamedDomainObjectProvider suite = testing.getSuites().register("integrationTest", JvmTestSuite.class);
        suite.configure(testSuite -> {
            testSuite.getTestType().set((Object)"integration-test");
            testSuite.getDependencies().getImplementation().add(project.getDependencies().platform((Object)Utils.getPlatform(project)));
            testSuite.getDependencies().getImplementation().add((Dependency)testSuite.getDependencies().project());
            testSuite.getTargets().configureEach(target -> target.getTestTask().configure(testTask -> testTask.shouldRunAfter(new Object[]{testing.getSuites().named("test")})));
            TestLoggerExtension testLogger = (TestLoggerExtension)project.getExtensions().getByType(TestLoggerExtension.class);
            testLogger.setSlowThreshold(Long.valueOf(2000L));
        });
        project.getTasks().named("check").configure(checkTask -> checkTask.dependsOn(new Object[]{suite}));
    }
}

