/*
 * Decompiled with CFR 0.152.
 */
package de.cotto.javaconventions.plugins;

import de.cotto.javaconventions.Utils;
import java.util.List;
import net.ltgt.gradle.errorprone.CheckSeverity;
import net.ltgt.gradle.errorprone.ErrorProneOptions;
import net.ltgt.gradle.nullaway.NullAwayExtension;
import net.ltgt.gradle.nullaway.NullAwayOptions;
import net.ltgt.gradle.nullaway.NullAwayPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class ErrorPronePlugin
implements Plugin<Project> {
    private static final String ANNOTATED_PACKAGES = "de.cotto";

    public void apply(Project project) {
        PluginManager pluginManager = project.getPluginManager();
        DependencyHandler dependencies = project.getDependencies();
        ExtensionContainer extensions = project.getExtensions();
        pluginManager.apply(net.ltgt.gradle.errorprone.ErrorPronePlugin.class);
        pluginManager.apply(NullAwayPlugin.class);
        NullAwayExtension nullAwayExtension = (NullAwayExtension)extensions.getByType(NullAwayExtension.class);
        nullAwayExtension.getAnnotatedPackages().add((Object)ANNOTATED_PACKAGES);
        project.getTasks().withType(JavaCompile.class).configureEach(compileTask -> {
            ErrorProneOptions errorProne = this.getExtension(compileTask.getOptions(), ErrorProneOptions.class);
            this.configureErrorProne(errorProne);
            NullAwayOptions nullAway = this.getExtension(errorProne, NullAwayOptions.class);
            this.configureNullAway(nullAway);
        });
        String configurationName = "errorprone";
        dependencies.add(configurationName, (Object)dependencies.platform((Object)Utils.getPlatform(project)));
        dependencies.add(configurationName, (Object)"com.google.errorprone:error_prone_core");
        dependencies.add(configurationName, (Object)"com.uber.nullaway:nullaway");
    }

    private void configureErrorProne(ErrorProneOptions errorProne) {
        errorProne.disable(new String[]{"EqualsGetClass"});
        errorProne.getExcludedPaths().set((Object)".*/generated/.*");
    }

    private void configureNullAway(NullAwayOptions nullAway) {
        List.of("org.mockito.Mock", "org.mockito.InjectMocks", "org.junit.jupiter.api.io.TempDir", "org.springframework.boot.test.mock.mockito.MockBean", "org.springframework.beans.factory.annotation.Autowired", "org.mockito.Captor", "org.springframework.beans.factory.annotation.Value").forEach(arg_0 -> ((ListProperty)nullAway.getExcludedFieldAnnotations()).add(arg_0));
        nullAway.getExcludedClassAnnotations().add((Object)"org.springframework.boot.context.properties.ConfigurationProperties");
        nullAway.getSeverity().set((Object)CheckSeverity.ERROR);
    }

    private <T> T getExtension(Object source, Class<T> clazz) {
        return (T)((ExtensionAware)source).getExtensions().getByType(clazz);
    }
}

