/*
 * Decompiled with CFR 0.152.
 */
package de.cotto.javaconventions.plugins;

import de.cotto.javaconventions.Utils;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;

public abstract class PmdPlugin
implements Plugin<Project> {
    private static final String PMD_RULESET_XML = "/pmd-ruleset.xml";

    public void apply(Project project) {
        project.getPluginManager().apply(org.gradle.api.plugins.quality.PmdPlugin.class);
        PmdExtension pmd = (PmdExtension)project.getExtensions().getByType(PmdExtension.class);
        pmd.setToolVersion(Utils.getVersionFromCatalog(project, "pmdCpd"));
        pmd.setConsoleOutput(true);
        pmd.setRuleSetFiles((FileCollection)project.files(new Object[]{Utils.getResourceFile(project, PMD_RULESET_XML)}));
        pmd.setRuleSets(List.of());
        Utils.shouldRunBeforeTests(project, Pmd.class);
    }
}

