/*
 * Decompiled with CFR 0.152.
 */
package de.cotto.javaconventions.plugins;

import de.cotto.javaconventions.Utils;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.tasks.JacocoCoverageVerification;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.gradle.testing.jacoco.tasks.rules.JacocoViolationRule;

public abstract class JacocoPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        project.getPluginManager().apply(org.gradle.testing.jacoco.plugins.JacocoPlugin.class);
        JacocoPluginExtension jacoco = (JacocoPluginExtension)project.getExtensions().getByType(JacocoPluginExtension.class);
        jacoco.setToolVersion(Utils.getVersionFromCatalog(project, "jacoco"));
        Utils.mustRunAfterTests(project, JacocoReport.class);
        TaskCollection jacocoCoverageVerifications = project.getTasks().withType(JacocoCoverageVerification.class);
        jacocoCoverageVerifications.configureEach(verificationTask -> {
            verificationTask.dependsOn(new Object[]{project.getTasks().withType(Test.class)});
            verificationTask.dependsOn(new Object[]{project.getTasks().withType(JacocoReport.class)});
            verificationTask.dependsOn(new Object[]{project.getTasks().withType(CheckForExecutionDataTask.class)});
            this.setExecutionDataPath(project, verificationTask.getExecutionData());
            verificationTask.getViolationRules().rule(this.rule("BRANCH", 0.9));
            verificationTask.getViolationRules().rule(this.rule("INSTRUCTION", 0.9));
            verificationTask.getViolationRules().rule(this.rule("METHOD", 0.9));
            verificationTask.getViolationRules().rule(this.rule("CLASS", 1.0));
        });
        project.getTasks().register("checkForExecutionData", CheckForExecutionDataTask.class).configure(task -> {
            task.dependsOn(new Object[]{project.getTasks().withType(Test.class)});
            this.setExecutionDataPath(project, task.getExecutionData());
        });
        project.getTasks().named("check").configure(checkTask -> checkTask.dependsOn(new Object[]{jacocoCoverageVerifications}));
    }

    private void setExecutionDataPath(Project project, ConfigurableFileCollection fileCollection) {
        fileCollection.setFrom(new Object[]{project.fileTree((Object)project.getBuildDir()).include(new String[]{"/jacoco/*.exec"})});
    }

    private Action<JacocoViolationRule> rule(String counter, double minimum) {
        return rule -> rule.limit(limit -> {
            limit.setValue("COVEREDRATIO");
            limit.setCounter(counter);
            limit.setMinimum(BigDecimal.valueOf(minimum));
        });
    }

    public static abstract class CheckForExecutionDataTask
    extends DefaultTask {
        private final Project project;

        @Inject
        public CheckForExecutionDataTask(Project project) {
            this.project = project;
        }

        @InputFiles
        public abstract ConfigurableFileCollection getExecutionData();

        @TaskAction
        public void check() {
            if (this.getExecutionData().isEmpty()) {
                throw new GradleException("No tests found for " + this.project);
            }
        }
    }
}

