/*
 * Decompiled with CFR 0.152.
 */
package de.cotto.javaconventions.plugins;

import com.adarshr.gradle.testlogger.TestLoggerExtension;
import com.adarshr.gradle.testlogger.TestLoggerPlugin;
import com.adarshr.gradle.testlogger.theme.ThemeType;
import de.cotto.javaconventions.Utils;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.testing.base.TestingExtension;

public abstract class TestsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        project.getPluginManager().apply(TestLoggerPlugin.class);
        TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
        testing.getSuites().withType(JvmTestSuite.class).configureEach(testSuite -> {
            testSuite.useJUnitJupiter();
            testSuite.getDependencies().getImplementation().add(project.getDependencies().platform((Object)Utils.getFromCatalog(project, "platform")));
            testSuite.getDependencies().getImplementation().add((Dependency)Utils.getFromCatalog(project, "testing-equalsverifier"));
            testSuite.getDependencies().getImplementation().add((Dependency)Utils.getFromCatalog(project, "testing-assertJCore"));
            testSuite.getDependencies().getRuntimeOnly().add((Dependency)Utils.getFromCatalog(project, "slf4jNop"));
        });
        project.getTasks().withType(Test.class).configureEach(testTask -> {
            testTask.addTestListener((TestListener)new FailIfIgnoredTestListener());
            testTask.getSystemProperties().put("unit.jupiter.displayname.generator.default", "org.junit.jupiter.api.DisplayNameGenerator$ReplaceUnderscores");
        });
        TestLoggerExtension testLogger = (TestLoggerExtension)project.getExtensions().getByType(TestLoggerExtension.class);
        testLogger.setTheme(ThemeType.STANDARD_PARALLEL);
        testLogger.setSlowThreshold(Long.valueOf(1000L));
        testLogger.setShowSimpleNames(Boolean.valueOf(true));
        testLogger.setShowOnlySlow(Boolean.valueOf(true));
    }

    private static class FailIfIgnoredTestListener
    extends NoopListener {
        private FailIfIgnoredTestListener() {
        }

        @Override
        public void afterTest(TestDescriptor testDescriptor, TestResult result) {
            if (result.getSkippedTestCount() > 0L) {
                throw new GradleException("Do not ignore test cases! Ignored test: " + testDescriptor);
            }
        }
    }

    private static abstract class NoopListener
    implements TestListener {
        private NoopListener() {
        }

        public void beforeSuite(TestDescriptor suite) {
        }

        public void afterSuite(TestDescriptor suite, TestResult result) {
        }

        public void beforeTest(TestDescriptor testDescriptor) {
        }

        public void afterTest(TestDescriptor testDescriptor, TestResult result) {
        }
    }
}

