/*
 * Decompiled with CFR 0.152.
 */
package de.cotto.javaconventions.plugins;

import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.SpotBugsPlugin;
import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import de.cotto.javaconventions.Utils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskCollection;

public abstract class SpotbugsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(SpotBugsPlugin.class);
        SpotBugsExtension spotbugs = (SpotBugsExtension)project.getExtensions().getByType(SpotBugsExtension.class);
        spotbugs.getExcludeFilter().set(project.file((Object)(project.getRootDir() + "/config/spotbugs-exclude.xml")));
        spotbugs.getToolVersion().set((Object)Utils.getVersionFromCatalog(project, "spotbugs"));
        TaskCollection spotbugsTasks = project.getTasks().withType(SpotBugsTask.class);
        spotbugsTasks.configureEach(task -> {
            ((SpotBugsReport)task.getReports().create("xml")).getRequired().set((Object)false);
            ((SpotBugsReport)task.getReports().create("html")).getRequired().set((Object)true);
        });
    }
}

