/*
 * Decompiled with CFR 0.152.
 */
package de.cotto.javaconventions;

import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.artifacts.VersionCatalogsExtension;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;

public class Utils {
    public static MinimalExternalModuleDependency getFromCatalog(Project project, String alias) {
        VersionCatalog libs = Utils.getLibs(project);
        return (MinimalExternalModuleDependency)((Provider)libs.findLibrary(alias).orElseThrow()).get();
    }

    public static String getVersionFromCatalog(Project project, String alias) {
        VersionCatalog libs = Utils.getLibs(project);
        return ((VersionConstraint)libs.findVersion(alias).orElseThrow()).getRequiredVersion();
    }

    public static <T extends Task> void shouldRunBeforeTests(Project project, Class<T> taskType) {
        TaskCollection tasks = project.getTasks().withType(taskType);
        Utils.testTasks(project).forEach(testTask -> testTask.shouldRunAfter(new Object[]{tasks}));
    }

    public static <T extends Task> void mustRunAfterTests(Project project, Class<T> taskType) {
        TaskCollection<Test> testTasks = Utils.testTasks(project);
        Utils.tasksWithType(project, taskType).forEach(task -> task.shouldRunAfter(new Object[]{testTasks}));
    }

    private static VersionCatalog getLibs(Project project) {
        return ((VersionCatalogsExtension)project.getExtensions().getByType(VersionCatalogsExtension.class)).named("libs");
    }

    private static TaskCollection<Test> testTasks(Project project) {
        return Utils.tasksWithType(project, Test.class);
    }

    private static <T extends Task> TaskCollection<T> tasksWithType(Project project, Class<T> taskType) {
        return project.getTasks().withType(taskType);
    }
}

