/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.sqlmapper.handlers;

import de.bytefish.sqlmapper.handlers.BooleanValueHandler;
import de.bytefish.sqlmapper.handlers.ByteArrayValueHandler;
import de.bytefish.sqlmapper.handlers.ByteValueHandler;
import de.bytefish.sqlmapper.handlers.DoubleValueHandler;
import de.bytefish.sqlmapper.handlers.FloatValueHandler;
import de.bytefish.sqlmapper.handlers.IValueHandler;
import de.bytefish.sqlmapper.handlers.IValueHandlerProvider;
import de.bytefish.sqlmapper.handlers.IntegerValueHandler;
import de.bytefish.sqlmapper.handlers.LocalDateTimeValueHandler;
import de.bytefish.sqlmapper.handlers.LocalDateValueHandler;
import de.bytefish.sqlmapper.handlers.LongValueHandler;
import de.bytefish.sqlmapper.handlers.ShortValueHandler;
import de.bytefish.sqlmapper.handlers.StringValueHandler;
import de.bytefish.sqlmapper.handlers.ValueHandler;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ValueHandlerProvider
implements IValueHandlerProvider {
    private Map<Type, ValueHandler> valueHandlers = new HashMap<Type, ValueHandler>();

    public ValueHandlerProvider() {
        this.add(new BooleanValueHandler());
        this.add(new ByteValueHandler());
        this.add(new DoubleValueHandler());
        this.add(new FloatValueHandler());
        this.add(new LocalDateValueHandler());
        this.add(new LocalDateTimeValueHandler());
        this.add(new IntegerValueHandler());
        this.add(new ShortValueHandler());
        this.add(new LongValueHandler());
        this.add(new StringValueHandler());
        this.add(new ByteArrayValueHandler());
    }

    public <TTargetType> ValueHandlerProvider add(IValueHandler<TTargetType> valueHandler) {
        Type targetType = valueHandler.getTargetType();
        if (this.valueHandlers.containsKey(targetType)) {
            throw new RuntimeException(String.format("TargetType '%s' has already been registered", targetType));
        }
        this.valueHandlers.put(valueHandler.getTargetType(), valueHandler);
        return this;
    }

    @Override
    public <TTargetType> IValueHandler<TTargetType> resolve(Type targetType) {
        if (!this.valueHandlers.containsKey(targetType)) {
            throw new RuntimeException(String.format("TargetType '%s' has not been registered", targetType));
        }
        return (IValueHandler)this.valueHandlers.get(targetType);
    }

    public <TTargetType> ValueHandlerProvider override(IValueHandler<TTargetType> valueHandler) {
        this.valueHandlers.put(valueHandler.getTargetType(), valueHandler);
        return this;
    }

    public String toString() {
        String valueHandlersString = this.valueHandlers.entrySet().stream().map(e -> ((ValueHandler)e.getValue()).toString()).collect(Collectors.joining(", "));
        return "ValueHandlerProvider{valueHandlers=[" + valueHandlersString + "]" + '}';
    }
}

