/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.sqlmapper;

import de.bytefish.sqlmapper.handlers.IValueHandler;
import de.bytefish.sqlmapper.handlers.IValueHandlerProvider;
import de.bytefish.sqlmapper.handlers.ValueHandlerProvider;
import de.bytefish.sqlmapper.mapping.IPropertyMapping;
import de.bytefish.sqlmapper.mapping.PropertyMapping;
import de.bytefish.sqlmapper.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public abstract class AbstractMap<TEntity> {
    private IValueHandlerProvider provider;
    private String schemaName;
    private String tableName;
    private List<IPropertyMapping<TEntity>> mappings;

    public AbstractMap(String tableName) {
        this("", tableName);
    }

    public AbstractMap(String schemaName, String tableName) {
        this(new ValueHandlerProvider(), schemaName, tableName);
    }

    public AbstractMap(IValueHandlerProvider valueHandlerProvider, String schemaName, String tableName) {
        this.provider = valueHandlerProvider;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.mappings = new ArrayList<IPropertyMapping<TEntity>>();
    }

    protected <TProperty> void map(String columnName, Class<TProperty> type, BiConsumer<TEntity, TProperty> setter) {
        IValueHandler handler = this.provider.resolve(type);
        this.mappings.add(new PropertyMapping<TEntity, TProperty>(columnName, setter, handler));
    }

    public List<IPropertyMapping<TEntity>> getMappings() {
        return this.mappings;
    }

    public String getFullQualifiedTableName() {
        if (StringUtils.isNullOrWhiteSpace(this.schemaName)) {
            return this.tableName;
        }
        return String.format("%1$s.%2$s", this.schemaName, this.tableName);
    }
}

