/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.postgisbulkinsert.utils;

import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.model.ColumnDefinition;
import de.bytefish.pgbulkinsert.pgsql.PgBinaryWriter;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class PgBulkInsertUtils {
    private PgBulkInsertUtils() {
    }

    public static <TEntity, TProperty> void addColumn(AbstractMapping<TEntity> mapping, String columnName, final IValueHandler<TProperty> valueHandler, final Function<TEntity, TProperty> propertyGetter) {
        BiConsumer action = new BiConsumer<PgBinaryWriter, TEntity>(){

            @Override
            public void accept(PgBinaryWriter binaryWriter, TEntity entity) {
                binaryWriter.write(valueHandler, propertyGetter.apply(entity));
            }
        };
        ColumnDefinition columnDefinition = new ColumnDefinition(columnName, action);
        mapping.getColumns().add(columnDefinition);
    }
}

