/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.row;

import de.bytefish.pgbulkinsert.exceptions.BinaryWriteFailedException;
import de.bytefish.pgbulkinsert.pgsql.PgBinaryWriter;
import de.bytefish.pgbulkinsert.pgsql.handlers.ValueHandlerProvider;
import de.bytefish.pgbulkinsert.row.SimpleRow;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import de.bytefish.pgbulkinsert.util.StringUtils;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.PGConnection;
import org.postgresql.copy.PGCopyOutputStream;

public class SimpleRowWriter
implements AutoCloseable {
    private final Table table;
    private final PgBinaryWriter writer;
    private final ValueHandlerProvider provider;
    private final Map<String, Integer> lookup;
    private Function<String, String> nullCharacterHandler;
    private boolean isOpened;
    private boolean isClosed;

    public SimpleRowWriter(Table table, PGConnection connection) throws SQLException {
        this(table, connection, false);
    }

    public SimpleRowWriter(Table table, PGConnection connection, boolean usePostgresQuoting) throws SQLException {
        this.table = table;
        this.isClosed = false;
        this.isOpened = false;
        this.nullCharacterHandler = val -> val;
        this.provider = new ValueHandlerProvider();
        this.lookup = new HashMap<String, Integer>();
        for (int ordinal = 0; ordinal < table.columns.length; ++ordinal) {
            this.lookup.put(table.columns[ordinal], ordinal);
        }
        this.writer = new PgBinaryWriter((OutputStream)new PGCopyOutputStream(connection, table.getCopyCommand(usePostgresQuoting), 1));
        this.isClosed = false;
        this.isOpened = true;
    }

    public synchronized void startRow(Consumer<SimpleRow> consumer) {
        if (!this.isOpened) {
            throw new BinaryWriteFailedException("The SimpleRowWriter has not been opened");
        }
        if (this.isClosed) {
            throw new BinaryWriteFailedException("The PGCopyOutputStream has already been closed");
        }
        try {
            this.writer.startRow(this.table.columns.length);
            SimpleRow row = new SimpleRow(this.provider, this.lookup, this.nullCharacterHandler);
            consumer.accept(row);
            row.writeRow(this.writer);
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.isOpened = false;
        this.isClosed = true;
        this.writer.close();
    }

    public void enableNullCharacterHandler() {
        this.nullCharacterHandler = val -> StringUtils.removeNullCharacter((String)val);
    }

    public void setNullCharacterHandler(Function<String, String> nullCharacterHandler) {
        this.nullCharacterHandler = nullCharacterHandler;
    }

    public static class Table {
        private final @Nullable String schema;
        private final String table;
        private final String[] columns;

        public Table(String table, String ... columns) {
            this((String)null, table, columns);
        }

        public Table(@Nullable String schema, String table, String ... columns) {
            this.schema = schema;
            this.table = table;
            this.columns = columns;
        }

        public @Nullable String getSchema() {
            return this.schema;
        }

        public String getTable() {
            return this.table;
        }

        public String[] getColumns() {
            return this.columns;
        }

        public String getFullyQualifiedTableName(boolean usePostgresQuoting) {
            return PostgreSqlUtils.getFullyQualifiedTableName((String)this.schema, (String)this.table, (boolean)usePostgresQuoting);
        }

        public String getCopyCommand(boolean usePostgresQuoting) {
            String commaSeparatedColumns = Arrays.stream(this.columns).map(x -> usePostgresQuoting ? PostgreSqlUtils.quoteIdentifier((String)x) : x).collect(Collectors.joining(", "));
            return String.format("COPY %1$s(%2$s) FROM STDIN BINARY", this.getFullyQualifiedTableName(usePostgresQuoting), commaSeparatedColumns);
        }
    }
}

