/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.pgsql.handlers;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.pgsql.model.range.Range;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.postgresql.util.PGobject;

public class RangeTypesTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Override
    protected void onSetUpBeforeTransaction() throws Exception {
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.time_table(\n", this.schema) + "  col_tstzrange tstzrange,  col_tsrange tsrange,  col_int4range int4range,  col_int8range int8range,  col_numrange numrange,  col_daterange daterange);";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    @Test
    public void test_SaveTsRange_Inclusive_Bounds() throws SQLException {
        ArrayList<RangeEntity> entities = new ArrayList<RangeEntity>();
        RangeEntity entity0 = new RangeEntity();
        LocalDateTime lower = LocalDateTime.of(2020, 1, 1, 0, 0, 0, 0);
        LocalDateTime upper = LocalDateTime.of(2020, 3, 1, 0, 0, 0, 0);
        entity0.timeRange = new Range((Object)lower, (Object)upper);
        entities.add(entity0);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new RangeEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v0 = (PGobject)rs.getObject("col_tsrange");
            Assert.assertEquals((Object)"[\"2020-01-01 00:00:00\",\"2020-03-01 00:00:00\"]", (Object)v0.getValue());
        }
    }

    @Test
    public void test_SaveDateRange_Inclusive_Bounds() throws SQLException {
        ArrayList<RangeEntity> entities = new ArrayList<RangeEntity>();
        RangeEntity entity0 = new RangeEntity();
        LocalDate lower = LocalDate.of(2020, 1, 1);
        LocalDate upper = LocalDate.of(2020, 3, 1);
        entity0.dateRange = new Range((Object)lower, (Object)upper);
        entities.add(entity0);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new RangeEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v0 = (PGobject)rs.getObject("col_daterange");
            Assert.assertEquals((Object)"[2020-01-01,2020-03-02)", (Object)v0.getValue());
        }
    }

    @Test
    public void test_SaveInt4Range_Inclusive_Bounds() throws SQLException {
        ArrayList<RangeEntity> entities = new ArrayList<RangeEntity>();
        RangeEntity entity0 = new RangeEntity();
        int lower = 1;
        int upper = 8;
        entity0.int4Range = new Range((Object)lower, (Object)upper);
        entities.add(entity0);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new RangeEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v0 = (PGobject)rs.getObject("col_int4range");
            Assert.assertEquals((Object)"[1,9)", (Object)v0.getValue());
        }
    }

    @Test
    public void test_SaveInt8Range_Inclusive_Bounds() throws SQLException {
        ArrayList<RangeEntity> entities = new ArrayList<RangeEntity>();
        RangeEntity entity0 = new RangeEntity();
        long lower = 1L;
        long upper = 8L;
        entity0.int8Range = new Range((Object)lower, (Object)upper);
        entities.add(entity0);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new RangeEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v0 = (PGobject)rs.getObject("col_int8range");
            Assert.assertEquals((Object)"[1,9)", (Object)v0.getValue());
        }
    }

    @Test
    public void test_SaveNumericRange_Inclusive_Bounds() throws SQLException {
        ArrayList<RangeEntity> entities = new ArrayList<RangeEntity>();
        RangeEntity entity0 = new RangeEntity();
        double lower = 1.2;
        double upper = 8.2;
        entity0.numericRange = new Range((Object)lower, (Object)upper);
        entities.add(entity0);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new RangeEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v0 = (PGobject)rs.getObject("col_numrange");
            Assert.assertEquals((Object)"[1.2,8.2]", (Object)v0.getValue());
        }
    }

    @Test
    public void test_SaveTsTzRange_Inclusive_Bounds() throws SQLException {
        ArrayList<RangeEntity> entities = new ArrayList<RangeEntity>();
        RangeEntity entity0 = new RangeEntity();
        ZonedDateTime lower = ZonedDateTime.of(2020, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        ZonedDateTime upper = ZonedDateTime.of(2020, 3, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        entity0.timeTzRange = new Range((Object)lower, (Object)upper);
        entities.add(entity0);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new RangeEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v0 = (PGobject)rs.getObject("col_tstzrange");
            Assert.assertEquals((Object)"[\"2020-01-01 00:00:00+00\",\"2020-03-01 00:00:00+00\"]", (Object)v0.getValue());
        }
    }

    @Test
    public void test_SaveTsTzRange_UpperBound_Null() throws SQLException {
        ArrayList<RangeEntity> entities = new ArrayList<RangeEntity>();
        RangeEntity entity0 = new RangeEntity();
        ZonedDateTime lower = ZonedDateTime.of(2020, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        Object upper = null;
        entity0.timeTzRange = new Range((Object)lower, upper);
        entities.add(entity0);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new RangeEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v0 = (PGobject)rs.getObject("col_tstzrange");
            Assert.assertEquals((Object)"[\"2020-01-01 00:00:00+00\",)", (Object)v0.getValue());
        }
    }

    @Test
    public void test_SaveTsTzRange_LowerBound_Null() throws SQLException {
        ArrayList<RangeEntity> entities = new ArrayList<RangeEntity>();
        RangeEntity entity0 = new RangeEntity();
        Object lower = null;
        ZonedDateTime upper = ZonedDateTime.of(2020, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        entity0.timeTzRange = new Range(lower, (Object)upper);
        entities.add(entity0);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new RangeEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v0 = (PGobject)rs.getObject("col_tstzrange");
            Assert.assertEquals((Object)"(,\"2020-01-01 00:00:00+00\"]", (Object)v0.getValue());
        }
    }

    @Test
    public void test_SaveTsTzRange_Empty() throws SQLException {
        ArrayList<RangeEntity> entities = new ArrayList<RangeEntity>();
        RangeEntity entity0 = new RangeEntity();
        Object lower = null;
        Object upper = null;
        entity0.timeTzRange = new Range(lower, upper);
        entities.add(entity0);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new RangeEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v0 = (PGobject)rs.getObject("col_tstzrange");
            Assert.assertEquals((Object)"(,)", (Object)v0.getValue());
        }
    }

    private ResultSet getAll() throws SQLException {
        String sqlStatement = String.format("SELECT * FROM %s.time_table", this.schema);
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(sqlStatement);
    }

    private static class RangeEntity {
        public @Nullable Range<ZonedDateTime> timeTzRange;
        public @Nullable Range<LocalDateTime> timeRange;
        public @Nullable Range<Integer> int4Range;
        public @Nullable Range<Long> int8Range;
        public @Nullable Range<Number> numericRange;
        public @Nullable Range<LocalDate> dateRange;

        private RangeEntity() {
        }
    }

    private class RangeEntityMapping
    extends AbstractMapping<RangeEntity> {
        public RangeEntityMapping() {
            super(RangeTypesTest.this.schema, "time_table");
            this.mapTsTzRange("col_tstzrange", x -> x.timeTzRange);
            this.mapTsRange("col_tsrange", x -> x.timeRange);
            this.mapInt4Range("col_int4range", x -> x.int4Range);
            this.mapInt8Range("col_int8range", x -> x.int8Range);
            this.mapNumRange("col_numrange", x -> x.numericRange);
            this.mapDateRange("col_daterange", x -> x.dateRange);
        }
    }
}

