/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.pgsql.handlers;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class HstoreExtensionTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.installExtension();
        this.createTable();
    }

    @Override
    protected void onSetUpBeforeTransaction() {
    }

    private boolean installExtension() throws SQLException {
        String sqlStatement = "CREATE EXTENSION IF NOT EXISTS hstore;";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.hstore_table(\n", this.schema) + "                col_hstore hstore \n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    @Test
    public void saveAll_Hstore_Test() throws SQLException {
        ArrayList<HStoreEntity> entities = new ArrayList<HStoreEntity>();
        HashMap<String, String> hstoreData = new HashMap<String, String>();
        hstoreData.put("Philipp", "Cool Cool Cool!");
        HStoreEntity entity = new HStoreEntity();
        entity.setCol_hstore(hstoreData);
        entities.add(entity);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new HStoreEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            Map v = (Map)rs.getObject("col_hstore");
            Assert.assertEquals((long)1L, (long)v.size());
            Assert.assertTrue((boolean)v.containsKey("Philipp"));
            Assert.assertEquals((Object)"Cool Cool Cool!", v.get("Philipp"));
        }
    }

    private ResultSet getAll() throws SQLException {
        String sqlStatement = String.format("SELECT * FROM %s.hstore_table", this.schema);
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(sqlStatement);
    }

    private static class HStoreEntity {
        private @Nullable Map<String, String> col_hstore;

        private HStoreEntity() {
        }

        public @Nullable Map<String, String> getCol_hstore() {
            return this.col_hstore;
        }

        public void setCol_hstore(Map<String, String> col_hstore) {
            this.col_hstore = col_hstore;
        }
    }

    private class HStoreEntityMapping
    extends AbstractMapping<HStoreEntity> {
        public HStoreEntityMapping() {
            super(HstoreExtensionTest.this.schema, "hstore_table");
            this.mapHstore("col_hstore", HStoreEntity::getCol_hstore);
        }
    }
}

