/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.pgsql.handlers;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Box;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Circle;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Line;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.LineSegment;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Path;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Point;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Polygon;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;

public class GeometricTypesTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Override
    protected void onSetUpBeforeTransaction() throws Exception {
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.geometric_table(\n", this.schema) + "                col_point point, \n                col_path path, \n                col_polygon polygon, \n                col_box box, \n                col_line line, \n                col_circle circle, \n                col_line_segment lseg \n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    @Test
    public void saveAll_Point_Test() throws SQLException {
        ArrayList<GeometricEntity> entities = new ArrayList<GeometricEntity>();
        Point p = new Point(1.0, 2.0);
        GeometricEntity entity = new GeometricEntity();
        entity.setCol_point(p);
        entities.add(entity);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new GeometricEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGpoint v = (PGpoint)rs.getObject("col_point");
            Assert.assertEquals((double)1.0, (double)v.x, (double)1.0E-10);
            Assert.assertEquals((double)2.0, (double)v.y, (double)1.0E-10);
            Assert.assertNotNull((Object)v);
        }
    }

    @Test
    public void saveAll_Path_Test() throws SQLException {
        ArrayList<GeometricEntity> entities = new ArrayList<GeometricEntity>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(1.0, 2.0));
        points.add(new Point(3.0, 4.0));
        Path p = new Path(false, points);
        GeometricEntity entity = new GeometricEntity();
        entity.setCol_path(p);
        entities.add(entity);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new GeometricEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGpath v = (PGpath)rs.getObject("col_path");
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((Object)false, (Object)v.isClosed());
            Assert.assertEquals((long)2L, (long)v.points.length);
            Assert.assertEquals((double)1.0, (double)v.points[0].x, (double)1.0E-10);
            Assert.assertEquals((double)2.0, (double)v.points[0].y, (double)1.0E-10);
            Assert.assertEquals((double)3.0, (double)v.points[1].x, (double)1.0E-10);
            Assert.assertEquals((double)4.0, (double)v.points[1].y, (double)1.0E-10);
        }
    }

    @Test
    public void saveAll_Polygon_Test() throws SQLException {
        ArrayList<GeometricEntity> entities = new ArrayList<GeometricEntity>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(1.0, 2.0));
        points.add(new Point(3.0, 4.0));
        Polygon p = new Polygon(points);
        GeometricEntity entity = new GeometricEntity();
        entity.setCol_polygon(p);
        entities.add(entity);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new GeometricEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGpolygon v = (PGpolygon)rs.getObject("col_polygon");
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((long)2L, (long)v.points.length);
            Assert.assertEquals((double)1.0, (double)v.points[0].x, (double)1.0E-10);
            Assert.assertEquals((double)2.0, (double)v.points[0].y, (double)1.0E-10);
            Assert.assertEquals((double)3.0, (double)v.points[1].x, (double)1.0E-10);
            Assert.assertEquals((double)4.0, (double)v.points[1].y, (double)1.0E-10);
        }
    }

    @Test
    public void saveAll_Line_Test() throws SQLException {
        ArrayList<GeometricEntity> entities = new ArrayList<GeometricEntity>();
        Line line = new Line(1.0, 2.0, 3.0);
        GeometricEntity entity = new GeometricEntity();
        entity.setCol_line(line);
        entities.add(entity);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new GeometricEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGline v = (PGline)rs.getObject("col_line");
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((double)1.0, (double)v.a, (double)1.0E-10);
            Assert.assertEquals((double)2.0, (double)v.b, (double)1.0E-10);
            Assert.assertEquals((double)3.0, (double)v.c, (double)1.0E-10);
        }
    }

    @Test
    public void saveAll_Line_Segment_Test() throws SQLException {
        ArrayList<GeometricEntity> entities = new ArrayList<GeometricEntity>();
        Point p1 = new Point(1.0, 2.0);
        Point p2 = new Point(3.0, 4.0);
        LineSegment line = new LineSegment(p1, p2);
        GeometricEntity entity = new GeometricEntity();
        entity.setCol_line_segment(line);
        entities.add(entity);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new GeometricEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGlseg v = (PGlseg)rs.getObject("col_line_segment");
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((double)1.0, (double)v.point[0].x, (double)1.0E-10);
            Assert.assertEquals((double)2.0, (double)v.point[0].y, (double)1.0E-10);
            Assert.assertEquals((double)3.0, (double)v.point[1].x, (double)1.0E-10);
            Assert.assertEquals((double)4.0, (double)v.point[1].y, (double)1.0E-10);
        }
    }

    @Test
    public void saveAll_Box_Test() throws SQLException {
        ArrayList<GeometricEntity> entities = new ArrayList<GeometricEntity>();
        Point p1 = new Point(1.0, 2.0);
        Point p2 = new Point(3.0, 4.0);
        Box box = new Box(p1, p2);
        GeometricEntity entity = new GeometricEntity();
        entity.setCol_box(box);
        entities.add(entity);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new GeometricEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGbox v = (PGbox)rs.getObject("col_box");
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((double)3.0, (double)v.point[0].x, (double)1.0E-10);
            Assert.assertEquals((double)4.0, (double)v.point[0].y, (double)1.0E-10);
            Assert.assertEquals((double)1.0, (double)v.point[1].x, (double)1.0E-10);
            Assert.assertEquals((double)2.0, (double)v.point[1].y, (double)1.0E-10);
        }
    }

    @Test
    public void saveAll_Circle_Test() throws SQLException {
        ArrayList<GeometricEntity> entities = new ArrayList<GeometricEntity>();
        Point center = new Point(1.0, 2.0);
        double radius = 4.1;
        Circle circle = new Circle(center, radius);
        GeometricEntity entity = new GeometricEntity();
        entity.setCol_circle(circle);
        entities.add(entity);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new GeometricEntityMapping());
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGcircle v = (PGcircle)rs.getObject("col_circle");
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((double)1.0, (double)v.center.x, (double)1.0E-10);
            Assert.assertEquals((double)2.0, (double)v.center.y, (double)1.0E-10);
            Assert.assertEquals((double)4.1, (double)v.radius, (double)1.0E-10);
        }
    }

    private ResultSet getAll() throws SQLException {
        String sqlStatement = String.format("SELECT * FROM %s.geometric_table", this.schema);
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(sqlStatement);
    }

    private static class GeometricEntity {
        private @Nullable Point col_point;
        private @Nullable Path col_path;
        private @Nullable Polygon col_polygon;
        private @Nullable Box col_box;
        private @Nullable Line col_line;
        private @Nullable Circle col_circle;
        private @Nullable LineSegment col_line_segment;

        private GeometricEntity() {
        }

        public void setCol_point(Point col_point) {
            this.col_point = col_point;
        }

        public void setCol_path(Path col_path) {
            this.col_path = col_path;
        }

        public void setCol_polygon(Polygon col_polygon) {
            this.col_polygon = col_polygon;
        }

        public void setCol_box(Box col_box) {
            this.col_box = col_box;
        }

        public void setCol_line(Line col_line) {
            this.col_line = col_line;
        }

        public void setCol_circle(Circle col_circle) {
            this.col_circle = col_circle;
        }

        public void setCol_line_segment(LineSegment col_line_segment) {
            this.col_line_segment = col_line_segment;
        }

        public @Nullable Point getCol_point() {
            return this.col_point;
        }

        public @Nullable Path getCol_path() {
            return this.col_path;
        }

        public @Nullable Polygon getCol_polygon() {
            return this.col_polygon;
        }

        public @Nullable Box getCol_box() {
            return this.col_box;
        }

        public @Nullable Line getCol_line() {
            return this.col_line;
        }

        public @Nullable Circle getCol_circle() {
            return this.col_circle;
        }

        public @Nullable LineSegment getCol_line_segment() {
            return this.col_line_segment;
        }
    }

    private class GeometricEntityMapping
    extends AbstractMapping<GeometricEntity> {
        public GeometricEntityMapping() {
            super(GeometricTypesTest.this.schema, "geometric_table");
            this.mapPoint("col_point", GeometricEntity::getCol_point);
            this.mapPath("col_path", GeometricEntity::getCol_path);
            this.mapPolygon("col_polygon", GeometricEntity::getCol_polygon);
            this.mapBox("col_box", GeometricEntity::getCol_box);
            this.mapLine("col_line", GeometricEntity::getCol_line);
            this.mapCircle("col_circle", GeometricEntity::getCol_circle);
            this.mapLineSegment("col_line_segment", GeometricEntity::getCol_line_segment);
        }
    }
}

