/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.integration;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.BigDecimalValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class CustomValueHandlerIntegrationTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Test
    public void writeNumericTest() throws Exception {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.setDoubleValue(21.124);
        entities.add(entity);
        CustomValueHandlerMapping mapping = new CustomValueHandlerMapping();
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)mapping);
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            BigDecimal v = rs.getBigDecimal("numeric_column");
            Assert.assertEquals((Object)new BigDecimal("21.124"), (Object)v.stripTrailingZeros());
        }
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.unit_test\n", this.schema) + "            (\n                numeric_column numeric(20, 10)\n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    private ResultSet getAll() throws SQLException {
        String sqlStatement = String.format("SELECT * FROM %s.unit_test", this.schema);
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(sqlStatement);
    }

    private static class SampleEntity {
        private @Nullable Double doubleValue;

        private SampleEntity() {
        }

        public @Nullable Double getDoubleValue() {
            return this.doubleValue;
        }

        public void setDoubleValue(Double value) {
            this.doubleValue = value;
        }
    }

    public class CustomValueHandlerMapping
    extends AbstractMapping<SampleEntity> {
        public CustomValueHandlerMapping() {
            super(CustomValueHandlerIntegrationTest.this.schema, "unit_test");
            this.map("numeric_column", (IValueHandler)new DoubleNumericValueHandler(), SampleEntity::getDoubleValue);
        }
    }

    private static class DoubleNumericValueHandler
    extends BaseValueHandler<Double> {
        private IValueHandler<BigDecimal> bigDecimalIValueHandler = new BigDecimalValueHandler();

        protected void internalHandle(DataOutputStream buffer, Double value) throws Exception {
            BigDecimal decimal = BigDecimal.valueOf(value);
            this.bigDecimalIValueHandler.handle(buffer, (Object)decimal);
        }

        public int getLength(Double value) {
            throw new UnsupportedOperationException();
        }
    }
}

