/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.pgsql.handlers;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class PgBulkInsertPrimitivesTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Override
    protected void onSetUpBeforeTransaction() {
    }

    @Test
    public void saveAll_boolean_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_boolean = true;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            boolean v = rs.getBoolean("col_boolean");
            Assert.assertEquals((Object)true, (Object)v);
        }
    }

    @Test
    public void saveAll_Short_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_short = 1;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            short v = rs.getShort("col_smallint");
            Assert.assertEquals((long)1L, (long)v);
        }
    }

    @Test
    public void saveAll_Integer_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_integer = 1;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            int v = rs.getInt("col_integer");
            Assert.assertEquals((long)1L, (long)v);
        }
    }

    @Test
    public void saveAll_Single_Precision_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_float = 2.0001f;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            float v = rs.getFloat("col_real");
            Assert.assertEquals((double)2.0001, (double)v, (double)1.0E-6);
        }
    }

    @Test
    public void saveAll_Double_Precision_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_double = 2.0001;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            double v = rs.getDouble("col_double");
            Assert.assertEquals((double)2.0001, (double)v, (double)1.0E-10);
        }
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.unit_test\n", this.schema) + "            (\n                col_smallint smallint,\n                col_integer integer,\n                col_long bigint,\n                col_real real,\n                col_double double precision,\n                col_bytea bytea,\n                col_boolean boolean\n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    private ResultSet getAll() throws SQLException {
        String sqlStatement = String.format("SELECT * FROM %s.unit_test", this.schema);
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(sqlStatement);
    }

    private static class SampleEntity {
        public int col_integer;
        public float col_float;
        public double col_double;
        public long col_long;
        public short col_short;
        public @Nullable byte[] col_bytearray;
        public boolean col_boolean;

        private SampleEntity() {
        }

        public int getCol_integer() {
            return this.col_integer;
        }

        public float getCol_float() {
            return this.col_float;
        }

        public double getCol_double() {
            return this.col_double;
        }

        public long getCol_long() {
            return this.col_long;
        }

        public short getCol_short() {
            return this.col_short;
        }

        public @Nullable byte[] getCol_bytearray() {
            return this.col_bytearray;
        }

        public boolean isCol_boolean() {
            return this.col_boolean;
        }
    }

    private class SampleEntityMapping
    extends AbstractMapping<SampleEntity> {
        public SampleEntityMapping() {
            super(PgBulkInsertPrimitivesTest.this.schema, "unit_test");
            this.mapBoolean("col_boolean", SampleEntity::isCol_boolean);
            this.mapInteger("col_integer", SampleEntity::getCol_integer);
            this.mapShort("col_smallint", SampleEntity::getCol_short);
            this.mapLong("col_long", SampleEntity::getCol_long);
            this.mapByteArray("col_bytea", SampleEntity::getCol_bytearray);
            this.mapFloat("col_real", SampleEntity::getCol_float);
            this.mapDouble("col_double", SampleEntity::getCol_double);
        }
    }
}

