/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.pgsql.handlers;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class NumericArrayTypesTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Override
    protected void onSetUpBeforeTransaction() throws Exception {
    }

    @Test
    public void saveAll_NumericArray_Test() throws SQLException, UnknownHostException {
        ArrayEntity entity = new ArrayEntity();
        entity.bigDecimalArray = Arrays.asList(new BigDecimal("210000.00011234567"), new BigDecimal("310000.00011234567"));
        this.testArrayInternal("col_numeric_array", entity, entity.bigDecimalArray, x -> x);
    }

    @Test
    public void saveAll_DoubleArray_Test() throws SQLException, UnknownHostException {
        ArrayEntity entity = new ArrayEntity();
        entity.doubleArray = Arrays.asList(Double.parseDouble("210000.00011234567"), Double.parseDouble("310000.00011234567"));
        this.testArrayInternal("col_double_array", entity, entity.doubleArray, BigDecimal::doubleValue);
    }

    @Test
    public void saveAll_FloatArray_Test() throws SQLException, UnknownHostException {
        ArrayEntity entity = new ArrayEntity();
        entity.floatArray = Arrays.asList(Float.valueOf(Float.parseFloat("210000.00011234567")), Float.valueOf(Float.parseFloat("310000.00011234567")));
        this.testArrayInternal("col_float_array", entity, entity.floatArray, BigDecimal::floatValue);
    }

    @Test
    public void saveAll_LongArray_Test() throws SQLException, UnknownHostException {
        ArrayEntity entity = new ArrayEntity();
        entity.longArray = Arrays.asList(Long.parseLong("211234"), Long.parseLong("4534534"));
        this.testArrayInternal("col_long_array", entity, entity.longArray, BigDecimal::longValue);
    }

    @Test
    public void saveAll_ShortArray_Test() throws SQLException, UnknownHostException {
        ArrayEntity entity = new ArrayEntity();
        entity.shortArray = Arrays.asList(Short.parseShort("42"), Short.parseShort("34"));
        this.testArrayInternal("col_short_array", entity, entity.shortArray, Number::shortValue);
    }

    @Test
    public void saveAll_IntegerArray_Test() throws SQLException, UnknownHostException {
        ArrayEntity entity = new ArrayEntity();
        entity.integerArray = Arrays.asList(Integer.parseInt("3453455"), Integer.parseInt("5435345"));
        this.testArrayInternal("col_integer_array", entity, entity.integerArray, BigDecimal::intValue);
    }

    private <T> void testArrayInternal(String columnLabel, ArrayEntity entity, @Nullable List<T> samples, Function<BigDecimal, T> converter) throws SQLException {
        Objects.requireNonNull(samples, "samples");
        List<ArrayEntity> entities = Collections.singletonList(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new ArrayEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            Array z = rs.getArray(columnLabel);
            BigDecimal[] v = (BigDecimal[])z.getArray();
            for (int i = 0; i < samples.size(); ++i) {
                T element = converter.apply(v[i]);
                Assert.assertEquals(samples.get(i), element);
            }
        }
    }

    private ResultSet getAll() throws SQLException {
        String sqlStatement = String.format("SELECT * FROM %s.unit_test", this.schema);
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(sqlStatement);
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.unit_test\n", this.schema) + "            (\n                col_numeric_array numeric[],\n                col_double_array numeric[],\n                col_float_array numeric[],\n                col_long_array numeric[],\n                col_short_array numeric[],\n                col_integer_array numeric[],\n                col_boolean_array numeric[]\n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    private static class ArrayEntity {
        public @Nullable List<BigDecimal> bigDecimalArray;
        public @Nullable List<Double> doubleArray;
        public @Nullable List<Float> floatArray;
        public @Nullable List<Long> longArray;
        public @Nullable List<Short> shortArray;
        public @Nullable List<Integer> integerArray;

        private ArrayEntity() {
        }

        public @Nullable List<BigDecimal> getBigDecimalArray() {
            return this.bigDecimalArray;
        }

        public @Nullable List<Double> getDoubleArray() {
            return this.doubleArray;
        }

        public @Nullable List<Float> getFloatArray() {
            return this.floatArray;
        }

        public @Nullable List<Long> getLongArray() {
            return this.longArray;
        }

        public @Nullable List<Short> getShortArray() {
            return this.shortArray;
        }

        public @Nullable List<Integer> getIntegerArray() {
            return this.integerArray;
        }
    }

    private class ArrayEntityMapping
    extends AbstractMapping<ArrayEntity> {
        public ArrayEntityMapping() {
            super(NumericArrayTypesTest.this.schema, "unit_test");
            this.mapNumericArray("col_numeric_array", ArrayEntity::getBigDecimalArray);
            this.mapNumericArray("col_double_array", ArrayEntity::getDoubleArray);
            this.mapNumericArray("col_float_array", ArrayEntity::getFloatArray);
            this.mapNumericArray("col_long_array", ArrayEntity::getLongArray);
            this.mapNumericArray("col_short_array", ArrayEntity::getShortArray);
            this.mapNumericArray("col_integer_array", ArrayEntity::getIntegerArray);
        }
    }
}

