/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.integration;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class TimestampConversionTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Test
    public void timestampEntityExampleTest() throws SQLException {
        LocalDateTime emailCreationDate_asLocalDateTime = LocalDateTime.of(2013, 1, 1, 0, 0);
        Timestamp emailCreationDate_asTimeStamp = Timestamp.valueOf(emailCreationDate_asLocalDateTime);
        EMail email = new EMail();
        email.setEmailCreateTime(emailCreationDate_asTimeStamp);
        List<EMail> emails = Arrays.asList(email);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new EMailMapping(this.schema));
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), emails);
        Assert.assertEquals((long)1L, (long)this.getRowCount());
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.unit_test\n", this.schema) + "            (\n                email_create_time timestamp\n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    private int getRowCount() throws SQLException {
        Statement s = this.connection.createStatement();
        ResultSet r = s.executeQuery(String.format("SELECT COUNT(*) AS rowcount FROM %s.unit_test", this.schema));
        r.next();
        int count = r.getInt("rowcount");
        r.close();
        return count;
    }

    public static class EMail {
        private @Nullable Timestamp emailCreateTime;

        public @Nullable Timestamp getEmailCreateTime() {
            return this.emailCreateTime;
        }

        public void setEmailCreateTime(Timestamp emailCreateTime) {
            this.emailCreateTime = emailCreateTime;
        }
    }

    public static class EMailMapping
    extends AbstractMapping<EMail> {
        public EMailMapping(String schema) {
            super(schema, "unit_test");
            this.mapTimeStamp("email_create_time", x -> x != null ? Objects.requireNonNull(x.getEmailCreateTime(), "email_create_time").toLocalDateTime() : null);
        }
    }
}

