/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.integration;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.test.mapping.PersonMapping;
import de.bytefish.pgbulkinsert.test.model.Person;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class IntegrationTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Test
    public void bulkInsertPersonDataTest() throws SQLException {
        List<Person> personList = this.getPersonList(100000);
        PgBulkInsert bulkInsert = new PgBulkInsert((AbstractMapping)new PersonMapping(this.schema));
        bulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), personList.stream());
        Assert.assertEquals((long)100000L, (long)this.getRowCount());
    }

    private List<Person> getPersonList(int num) {
        ArrayList<Person> personList = new ArrayList<Person>();
        for (int pos = 0; pos < num; ++pos) {
            Person p = new Person();
            p.setFirstName("Philipp");
            p.setLastName("Wagner");
            p.setBirthDate(LocalDate.of(1986, 5, 12));
            personList.add(p);
        }
        return personList;
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.unit_test\n", this.schema) + "            (\n                first_name text,\n                last_name text,\n                birth_date date\n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    private int getRowCount() throws SQLException {
        Statement s = this.connection.createStatement();
        ResultSet r = s.executeQuery(String.format("SELECT COUNT(*) AS rowcount FROM %s.unit_test", this.schema));
        r.next();
        int count = r.getInt("rowcount");
        r.close();
        return count;
    }
}

