/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.model.range;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Range<TElementType> {
    private int flags;
    private @Nullable TElementType lowerBound;
    private @Nullable TElementType upperBound;

    public Range(@Nullable TElementType lowerBound, @Nullable TElementType upperBound) {
        this(lowerBound, true, false, upperBound, true, false);
    }

    public Range(@Nullable TElementType lowerBound, boolean lowerBoundIsInclusive, @Nullable TElementType upperBound, boolean upperBoundIsInclusive) {
        this(lowerBound, lowerBoundIsInclusive, false, upperBound, upperBoundIsInclusive, false);
    }

    public Range(@Nullable TElementType lowerBound, boolean lowerBoundIsInclusive, boolean lowerBoundInfinite, @Nullable TElementType upperBound, boolean upperBoundIsInclusive, boolean upperBoundInfinite) {
        this(lowerBound, upperBound, Range.evaluateBoundaryFlags(lowerBoundIsInclusive, upperBoundIsInclusive, lowerBoundInfinite, upperBoundInfinite));
    }

    private Range(@Nullable TElementType lowerBound, @Nullable TElementType upperBound, int flags) {
        this.lowerBound = (flags & 8) != 0 ? null : lowerBound;
        this.upperBound = (flags & 0x10) != 0 ? null : upperBound;
        this.flags = flags;
        if (lowerBound == null) {
            this.flags |= 8;
        }
        if (upperBound == null) {
            this.flags |= 0x10;
        }
        if (this.isEmptyRange(lowerBound, upperBound, flags)) {
            this.lowerBound = null;
            this.upperBound = null;
            this.flags = 1;
        }
    }

    private boolean isEmptyRange(@Nullable TElementType lowerBound, @Nullable TElementType upperBound, int flags) {
        if ((flags & 1) == 1) {
            return true;
        }
        if ((flags & 0x18) == 24) {
            return false;
        }
        if ((flags & 6) == 6) {
            return false;
        }
        return Objects.equals(lowerBound, upperBound);
    }

    private static int evaluateBoundaryFlags(boolean lowerBoundIsInclusive, boolean upperBoundIsInclusive, boolean lowerBoundInfinite, boolean upperBoundInfinite) {
        int result = 0;
        if (lowerBoundIsInclusive) {
            result |= 2;
        }
        if (upperBoundIsInclusive) {
            result |= 4;
        }
        if (lowerBoundInfinite) {
            result |= 8;
        }
        if (upperBoundInfinite) {
            result |= 0x10;
        }
        if ((result & 0xA) == 10) {
            result &= 0xFFFFFFFD;
        }
        if ((result & 0x14) == 20) {
            result &= 0xFFFFFFFB;
        }
        return result;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isEmpty() {
        return (this.flags & 1) != 0;
    }

    public boolean isLowerBoundInfinite() {
        return (this.flags & 8) != 0;
    }

    public boolean isUpperBoundInfinite() {
        return (this.flags & 0x10) != 0;
    }

    public @Nullable TElementType getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(TElementType lowerBound) {
        this.lowerBound = lowerBound;
    }

    public @Nullable TElementType getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(TElementType upperBound) {
        this.upperBound = upperBound;
    }
}

