/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql;

import de.bytefish.pgbulkinsert.exceptions.BinaryWriteFailedException;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PgBinaryWriter
implements AutoCloseable {
    private transient DataOutputStream buffer;
    private final int bufferSize;

    public PgBinaryWriter() {
        this(65536);
    }

    public PgBinaryWriter(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void open(OutputStream out) {
        this.buffer = new DataOutputStream(new BufferedOutputStream(out, this.bufferSize));
        this.writeHeader();
    }

    public void startRow(int numColumns) {
        try {
            this.buffer.writeShort(numColumns);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    public <TTargetType> void write(IValueHandler<TTargetType> handler, TTargetType value) {
        handler.handle(this.buffer, value);
    }

    public void writeBoolean(boolean value) {
        try {
            this.buffer.writeInt(1);
            if (value) {
                this.buffer.writeByte(1);
            } else {
                this.buffer.writeByte(0);
            }
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    public void writeByte(int value) {
        try {
            this.buffer.writeInt(1);
            this.buffer.writeByte(value);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    public void writeShort(int value) {
        try {
            this.buffer.writeInt(2);
            this.buffer.writeShort(value);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    public void writeInt(int value) {
        try {
            this.buffer.writeInt(4);
            this.buffer.writeInt(value);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    public void writeLong(long value) {
        try {
            this.buffer.writeInt(8);
            this.buffer.writeLong(value);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    public void writeFloat(float value) {
        try {
            this.buffer.writeInt(4);
            this.buffer.writeFloat(value);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    public void writeDouble(double value) {
        try {
            this.buffer.writeInt(8);
            this.buffer.writeDouble(value);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    public void writeNull() {
        try {
            this.buffer.writeInt(-1);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.buffer.writeShort(-1);
            this.buffer.flush();
            this.buffer.close();
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }

    private void writeHeader() {
        try {
            this.buffer.writeBytes("PGCOPY\n\u00ff\r\n\u0000");
            this.buffer.writeInt(0);
            this.buffer.writeInt(0);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (null != t) {
                throw new BinaryWriteFailedException(t);
            }
            throw new BinaryWriteFailedException(e);
        }
    }
}

