/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.utils;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.junit.After;
import org.junit.Before;

public abstract class TransactionalTestBase {
    protected Connection connection;
    protected String schema;

    @Before
    public void setUp() throws Exception {
        Properties properties = TransactionalTestBase.getProperties("db.properties");
        this.connection = DriverManager.getConnection(properties.getProperty("db.url"), properties.getProperty("db.user"), properties.getProperty("db.password"));
        this.schema = properties.getProperty("db.schema");
        this.onSetUpBeforeTransaction();
        this.connection.setAutoCommit(false);
        this.onSetUpInTransaction();
    }

    @After
    public void tearDown() throws Exception {
        this.onTearDownInTransaction();
        this.connection.rollback();
        this.onTearDownAfterTransaction();
        this.connection.close();
    }

    protected void onSetUpInTransaction() throws Exception {
    }

    protected void onSetUpBeforeTransaction() throws Exception {
    }

    protected void onTearDownInTransaction() throws Exception {
    }

    protected void onTearDownAfterTransaction() throws Exception {
    }

    private static Properties getProperties(String filename) {
        Properties props = new Properties();
        InputStream is = ClassLoader.getSystemResourceAsStream(filename);
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load unittest.properties", e);
        }
        return props;
    }
}

