/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.pgsql.handlers;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class PgBulkInsertTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Override
    protected void onSetUpBeforeTransaction() throws Exception {
    }

    @Test
    public void saveAll_numeric_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_numeric = new BigDecimal("210000.00011234567");
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            BigDecimal v = rs.getBigDecimal("col_numeric");
            Assert.assertEquals((Object)new BigDecimal("210000.00011234567"), (Object)v.stripTrailingZeros());
        }
    }

    @Test
    public void saveAll_boolean_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_boolean = true;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            boolean v = rs.getBoolean("col_boolean");
            Assert.assertEquals((Object)true, (Object)v);
        }
    }

    @Test
    public void saveAll_Short_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_short = 1;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            short v = rs.getShort("col_smallint");
            Assert.assertEquals((long)1L, (long)v);
        }
    }

    @Test
    public void saveAll_Integer_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_integer = 1;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            int v = rs.getInt("col_integer");
            Assert.assertEquals((long)1L, (long)v);
        }
    }

    @Test
    public void saveAll_Double_Precision_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_double = 2.0001;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            double v = rs.getDouble("col_double");
            Assert.assertEquals((double)2.0001, (double)v, (double)1.0E-10);
        }
    }

    @Test
    public void saveAll_Single_Precision_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_float = Float.valueOf(2.0001f);
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            float v = rs.getFloat("col_real");
            Assert.assertEquals((double)2.0001, (double)v, (double)1.0E-6);
        }
    }

    @Test
    public void saveAll_LocalDateTime_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_datetime = LocalDateTime.of(2010, 1, 1, 0, 0, 0, 10000);
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            Timestamp v = rs.getTimestamp("col_timestamp");
            Assert.assertEquals((Object)LocalDateTime.of(2010, 1, 1, 0, 0, 0, 10000), (Object)v.toLocalDateTime());
        }
    }

    @Test
    public void saveAll_LocalDateTime_Before_Postgres_Epoch_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_datetime = LocalDateTime.of(1712, 1, 3, 0, 0, 0, 10000);
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            Timestamp v = rs.getTimestamp("col_timestamp");
            Assert.assertEquals((Object)LocalDateTime.of(1712, 1, 3, 0, 0, 0, 10000), (Object)v.toLocalDateTime());
        }
    }

    @Test
    public void saveAll_LocalDate_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_date = LocalDate.of(2010, 1, 1);
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            Timestamp v = rs.getTimestamp("col_date");
            Assert.assertEquals((Object)LocalDateTime.of(2010, 1, 1, 0, 0, 0), (Object)v.toLocalDateTime());
        }
    }

    @Test
    public void saveAll_LocalTime_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_time = LocalTime.of(10, 10);
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            Time v = rs.getTime("col_time");
            Assert.assertEquals((Object)LocalTime.of(10, 10), (Object)v.toLocalTime());
        }
    }

    @Test
    public void saveAll_String_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_text = "ABC";
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            String v = rs.getString("col_text");
            Assert.assertEquals((Object)"ABC", (Object)v);
        }
    }

    @Test
    public void saveAll_Long_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_long = 1L;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            long v = rs.getLong("col_bigint");
            Assert.assertEquals((long)1L, (long)v);
        }
    }

    @Test
    public void saveAll_Jsonb_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        String jsonText = "{\"bar\": \"baz\", \"balance\": 7.77}";
        String expected_1 = "{\"bar\": \"baz\", \"balance\": 7.77}";
        String expected_2 = "{\"balance\": 7.77, \"bar\": \"baz\"}";
        SampleEntity entity = new SampleEntity();
        entity.col_jsonb = jsonText;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            String v = rs.getString("col_jsonb");
            Assert.assertTrue((expected_1.equals(v) || expected_2.equals(v) ? 1 : 0) != 0);
        }
    }

    @Test
    public void saveAll_Inet4_Test() throws SQLException, UnknownHostException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_inet4Address = (Inet4Address)Inet4Address.getByName("127.0.0.1");
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            String v = rs.getString("col_inet4");
            Assert.assertEquals((Object)"127.0.0.1", (Object)v);
        }
    }

    @Test
    public void saveAll_UUID_Test() throws SQLException, UnknownHostException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        UUID uuid = UUID.randomUUID();
        SampleEntity entity = new SampleEntity();
        entity.col_uuid = uuid;
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            String v = rs.getString("col_uuid");
            Assert.assertEquals((Object)uuid.toString(), (Object)v);
        }
    }

    @Test
    public void saveAll_Inet6_Test() throws SQLException, UnknownHostException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_inet6Address = (Inet6Address)Inet6Address.getByName("1080::8:800:200c:417a");
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            String v = rs.getString("col_inet6");
            Assert.assertEquals((Object)"1080::8:800:200c:417a", (Object)v);
        }
    }

    @Test
    public void saveAll_ByteArray_Test() throws SQLException, UnknownHostException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        byte byte1 = 1;
        byte byte2 = 2;
        entity.col_bytearray = new byte[]{byte1, byte2};
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            byte[] v = rs.getBytes("col_bytea");
            Assert.assertEquals((long)1L, (long)v[0]);
            Assert.assertEquals((long)2L, (long)v[1]);
        }
    }

    @Test
    public void saveAll_CustomIntegerArray_Test() throws SQLException, UnknownHostException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_int_array = Arrays.asList(new Integer(1), new Integer(2));
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            Array z = rs.getArray("col_int_array");
            Integer[] v = (Integer[])z.getArray();
            Assert.assertEquals((Object)1, (Object)v[0]);
            Assert.assertEquals((Object)2, (Object)v[1]);
        }
    }

    @Test
    public void saveAll_CustomDoubleArray_Test() throws SQLException, UnknownHostException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity = new SampleEntity();
        entity.col_double_array = Arrays.asList(new Double(1.131), new Double(2.412));
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            Array z = rs.getArray("col_double_array");
            Double[] v = (Double[])z.getArray();
            Assert.assertEquals((Object)new Double(1.131), (Object)v[0]);
            Assert.assertEquals((Object)new Double(2.412), (Object)v[1]);
        }
    }

    @Test
    public void saveAll_Multiple_Entities_Test() throws SQLException {
        ArrayList<SampleEntity> entities = new ArrayList<SampleEntity>();
        SampleEntity entity0 = new SampleEntity();
        entity0.col_long = 1L;
        SampleEntity entity1 = new SampleEntity();
        entity1.col_long = 2L;
        entities.add(entity0);
        entities.add(entity1);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new SampleEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        Assert.assertEquals((long)2L, (long)this.getRowCount());
        ResultSet rs = this.getAll();
        ArrayList<Long> values = new ArrayList<Long>();
        while (rs.next()) {
            values.add(rs.getLong("col_bigint"));
        }
        Assert.assertTrue((boolean)values.stream().anyMatch(x -> x == 1L));
        Assert.assertTrue((boolean)values.stream().anyMatch(x -> x == 2L));
    }

    private ResultSet getAll() throws SQLException {
        String sqlStatement = String.format("SELECT * FROM %s.unit_test", this.schema);
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(sqlStatement);
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.unit_test\n", this.schema) + "            (\n                col_smallint smallint,\n                col_integer integer,\n                col_money money,\n                col_bigint bigint,\n                col_long bigint,\n                col_timestamp timestamp,\n                col_real real,\n                col_double double precision,\n                col_bytea bytea,\n                col_uuid uuid,\n                col_inet4 inet,\n                col_inet6 inet,\n                col_macaddr macaddr,\n                col_date date,\n                col_time time,\n                col_interval interval,\n                col_boolean boolean,\n                col_text text,\n                col_int_array integer[], \n                col_double_array double precision[], \n                col_jsonb jsonb, \n                col_numeric numeric(50, 20) \n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    private int getRowCount() throws SQLException {
        Statement s = this.connection.createStatement();
        ResultSet r = s.executeQuery(String.format("SELECT COUNT(*) AS rowcount FROM %s.unit_test", this.schema));
        r.next();
        int count = r.getInt("rowcount");
        r.close();
        return count;
    }

    private class SampleEntityMapping
    extends AbstractMapping<SampleEntity> {
        public SampleEntityMapping() {
            super(PgBulkInsertTest.this.schema, "unit_test");
            this.mapText("col_text", SampleEntity::get_col_text);
            this.mapInteger("col_integer", SampleEntity::get_col_integer);
            this.mapShort("col_smallint", SampleEntity::get_col_short);
            this.mapTimeStamp("col_timestamp", SampleEntity::get_col_datetime);
            this.mapLong("col_bigint", SampleEntity::get_col_long);
            this.mapDate("col_date", SampleEntity::getCol_date);
            this.mapTime("col_time", SampleEntity::getCol_time);
            this.mapInet4Addr("col_inet4", SampleEntity::getCol_inet4Address);
            this.mapInet6Addr("col_inet6", SampleEntity::getCol_inet6Address);
            this.mapUUID("col_uuid", SampleEntity::get_col_uuid);
            this.mapByteArray("col_bytea", SampleEntity::getCol_bytearray);
            this.mapDouble("col_double", SampleEntity::get_col_double);
            this.mapFloat("col_real", SampleEntity::get_col_float);
            this.mapBoolean("col_boolean", SampleEntity::getCol_boolean);
            this.mapIntegerArray("col_int_array", SampleEntity::getCol_int_array);
            this.mapDoubleArray("col_double_array", SampleEntity::getCol_double_array);
            this.mapJsonb("col_jsonb", SampleEntity::getCol_jsonb);
            this.mapNumeric("col_numeric", SampleEntity::getCol_numeric);
        }
    }

    private class SampleEntity {
        public Integer col_integer;
        public LocalDate col_date;
        public LocalTime col_time;
        public LocalDateTime col_datetime;
        public Float col_float;
        public Double col_double;
        public String col_text;
        public Long col_long;
        public Short col_short;
        public UUID col_uuid;
        public Inet4Address col_inet4Address;
        public Inet6Address col_inet6Address;
        public byte[] col_bytearray;
        public Boolean col_boolean;
        public List<Integer> col_int_array;
        public List<Double> col_double_array;
        public String col_jsonb;
        public BigDecimal col_numeric;

        private SampleEntity() {
        }

        public Integer get_col_integer() {
            return this.col_integer;
        }

        public LocalDateTime get_col_datetime() {
            return this.col_datetime;
        }

        public Float get_col_float() {
            return this.col_float;
        }

        public Double get_col_double() {
            return this.col_double;
        }

        public String get_col_text() {
            return this.col_text;
        }

        public Long get_col_long() {
            return this.col_long;
        }

        public Short get_col_short() {
            return this.col_short;
        }

        public UUID get_col_uuid() {
            return this.col_uuid;
        }

        public LocalDate getCol_date() {
            return this.col_date;
        }

        public LocalTime getCol_time() {
            return this.col_time;
        }

        public Inet4Address getCol_inet4Address() {
            return this.col_inet4Address;
        }

        public Inet6Address getCol_inet6Address() {
            return this.col_inet6Address;
        }

        public byte[] getCol_bytearray() {
            return this.col_bytearray;
        }

        public Boolean getCol_boolean() {
            return this.col_boolean;
        }

        public List<Integer> getCol_int_array() {
            return this.col_int_array;
        }

        public List<Double> getCol_double_array() {
            return this.col_double_array;
        }

        public String getCol_jsonb() {
            return this.col_jsonb;
        }

        public BigDecimal getCol_numeric() {
            return this.col_numeric;
        }
    }
}

