/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.pgsql.handlers;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.pgsql.model.network.MacAddress;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.postgresql.util.PGobject;

public class NetworkTypesTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Override
    protected void onSetUpBeforeTransaction() throws Exception {
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.network_table(\n", this.schema) + "                col_mac_addr macaddr \n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    @Test
    public void saveAll_Point_Test() throws SQLException {
        ArrayList<NetworkEntity> entities = new ArrayList<NetworkEntity>();
        byte[] macAddressBytes = new byte[]{1, 2, 3, 4, 5, 6};
        MacAddress macAddress = new MacAddress(macAddressBytes);
        NetworkEntity entity = new NetworkEntity();
        entity.setCol_mac_addr(macAddress);
        entities.add(entity);
        PgBulkInsert pgBulkInsert = new PgBulkInsert((AbstractMapping)new NetworkEntityMapping());
        pgBulkInsert.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), entities.stream());
        ResultSet rs = this.getAll();
        while (rs.next()) {
            PGobject v = (PGobject)rs.getObject("col_mac_addr");
            Assert.assertNotNull((Object)v);
            Assert.assertEquals((Object)"macaddr", (Object)v.getType());
            Assert.assertEquals((Object)"01:02:03:04:05:06", (Object)v.getValue());
        }
    }

    private ResultSet getAll() throws SQLException {
        String sqlStatement = String.format("SELECT * FROM %s.network_table", this.schema);
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(sqlStatement);
    }

    private class NetworkEntityMapping
    extends AbstractMapping<NetworkEntity> {
        public NetworkEntityMapping() {
            super(NetworkTypesTest.this.schema, "network_table");
            this.mapMacAddress("col_mac_addr", NetworkEntity::getCol_mac_addr);
        }
    }

    private class NetworkEntity {
        private MacAddress col_mac_addr;

        private NetworkEntity() {
        }

        public MacAddress getCol_mac_addr() {
            return this.col_mac_addr;
        }

        public void setCol_mac_addr(MacAddress col_mac_addr) {
            this.col_mac_addr = col_mac_addr;
        }
    }
}

