/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.test.integration;

import de.bytefish.pgbulkinsert.PgBulkInsert;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.test.utils.TransactionalTestBase;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Issue23DuplicatesTest
extends TransactionalTestBase {
    @Override
    protected void onSetUpInTransaction() throws Exception {
        this.createTable();
    }

    @Test
    public void bulkInsertDataTest() throws SQLException {
        List<MyObject> testData = Arrays.asList(new MyObject(1, "vector_db", "xxxxxx", "postgis (JNDI)", "unique prop1"), new MyObject(2, "vector_db", "xxxxxx", "postgis (JNDI)", "unique prop2"), new MyObject(3, "vector_db", "xxxxxx", "postgis (JNDI)", "unique prop3"), new MyObject(4, "client_db", "xxxxxx", "postgis (JNDI)", "unique prop"));
        PgBulkInsert writer = new PgBulkInsert((AbstractMapping)new MyObjectMapper());
        writer.saveAll(PostgreSqlUtils.getPGConnection((Connection)this.connection), testData.stream());
        Assert.assertEquals((long)4L, (long)this.getRowCount());
        this.compareData(testData);
    }

    private boolean createTable() throws SQLException {
        String sqlStatement = String.format("CREATE TABLE %s.unit_test\n", this.schema) + "            (\n                pos int,\n                name text,\n                descr text,\n                type text,\n                otherProps text\n            );";
        Statement statement = this.connection.createStatement();
        return statement.execute(sqlStatement);
    }

    private int getRowCount() throws SQLException {
        Statement s = this.connection.createStatement();
        ResultSet r = s.executeQuery(String.format("SELECT COUNT(*) AS rowcount FROM %s.unit_test", this.schema));
        r.next();
        int count = r.getInt("rowcount");
        r.close();
        return count;
    }

    private void compareData(List<MyObject> testData) throws SQLException {
        Statement s = this.connection.createStatement();
        ResultSet resultSet = s.executeQuery(String.format("select * from %s.unit_test order by pos asc", this.schema));
        int pos = 0;
        while (resultSet.next()) {
            MyObject original = testData.get(pos);
            Assert.assertEquals((Object)resultSet.getString("name"), (Object)original.getName());
            Assert.assertEquals((Object)resultSet.getString("descr"), (Object)original.getDescr());
            Assert.assertEquals((Object)resultSet.getString("type"), (Object)original.getType());
            Assert.assertEquals((Object)resultSet.getString("otherProps"), (Object)original.getOtherProps());
            ++pos;
        }
    }

    private class MyObjectMapper
    extends AbstractMapping<MyObject> {
        public MyObjectMapper() {
            super(Issue23DuplicatesTest.this.schema, "unit_test");
            this.mapInteger("pos", MyObject::getPos);
            this.mapText("name", MyObject::getName);
            this.mapText("descr", MyObject::getDescr);
            this.mapText("type", MyObject::getType);
            this.mapText("otherProps", MyObject::getOtherProps);
        }
    }

    private class MyObject {
        private final int pos;
        private final String name;
        private final String descr;
        private final String type;
        private final String otherProps;

        public MyObject(int pos, String name, String descr, String type, String otherProps) {
            this.pos = pos;
            this.name = name;
            this.descr = descr;
            this.type = type;
            this.otherProps = otherProps;
        }

        public int getPos() {
            return this.pos;
        }

        public String getName() {
            return this.name;
        }

        public String getDescr() {
            return this.descr;
        }

        public String getType() {
            return this.type;
        }

        public String getOtherProps() {
            return this.otherProps;
        }
    }
}

