/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.mapping;

import de.bytefish.pgbulkinsert.function.ToBooleanFunction;
import de.bytefish.pgbulkinsert.function.ToFloatFunction;
import de.bytefish.pgbulkinsert.model.ColumnDefinition;
import de.bytefish.pgbulkinsert.model.TableDefinition;
import de.bytefish.pgbulkinsert.pgsql.PgBinaryWriter;
import de.bytefish.pgbulkinsert.pgsql.constants.DataType;
import de.bytefish.pgbulkinsert.pgsql.constants.ObjectIdentifier;
import de.bytefish.pgbulkinsert.pgsql.handlers.CollectionValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandlerProvider;
import de.bytefish.pgbulkinsert.pgsql.handlers.RangeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ValueHandlerProvider;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Box;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Circle;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Line;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.LineSegment;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Path;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Point;
import de.bytefish.pgbulkinsert.pgsql.model.geometric.Polygon;
import de.bytefish.pgbulkinsert.pgsql.model.network.MacAddress;
import de.bytefish.pgbulkinsert.pgsql.model.range.Range;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public abstract class AbstractMapping<TEntity> {
    protected boolean usePostgresQuoting;
    protected final IValueHandlerProvider provider;
    protected final TableDefinition table;
    protected final List<ColumnDefinition<TEntity>> columns;

    protected AbstractMapping(String schemaName, String tableName) {
        this(new ValueHandlerProvider(), schemaName, tableName, false);
    }

    protected AbstractMapping(String schemaName, String tableName, boolean usePostgresQuoting) {
        this(new ValueHandlerProvider(), schemaName, tableName, usePostgresQuoting);
    }

    protected AbstractMapping(IValueHandlerProvider provider, String schemaName, String tableName, boolean usePostgresQuoting) {
        this.provider = provider;
        this.table = new TableDefinition(schemaName, tableName);
        this.usePostgresQuoting = usePostgresQuoting;
        this.columns = new ArrayList<ColumnDefinition<TEntity>>();
    }

    protected void usePostgresQuoting(boolean enabled) {
        this.usePostgresQuoting = enabled;
    }

    protected <TElementType, TCollectionType extends Collection<TElementType>> void mapCollection(String columnName, DataType dataType, Function<TEntity, TCollectionType> propertyGetter) {
        IValueHandler valueHandler = this.provider.resolve(dataType);
        int valueOID = ObjectIdentifier.mapFrom(dataType);
        this.map(columnName, new CollectionValueHandler(valueOID, valueHandler), propertyGetter);
    }

    protected <TProperty> void map(String columnName, DataType dataType, Function<TEntity, TProperty> propertyGetter) {
        IValueHandler valueHandler = this.provider.resolve(dataType);
        this.map(columnName, valueHandler, propertyGetter);
    }

    protected <TProperty> void map(String columnName, IValueHandler<TProperty> valueHandler, Function<TEntity, TProperty> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.write(valueHandler, propertyGetter.apply(entity)));
    }

    protected void mapBoolean(String columnName, Function<TEntity, Boolean> propertyGetter) {
        this.map(columnName, DataType.Boolean, propertyGetter);
    }

    protected void mapBoolean(String columnName, ToBooleanFunction<TEntity> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.writeBoolean(propertyGetter.applyAsBoolean(entity)));
    }

    protected void mapByte(String columnName, Function<TEntity, Number> propertyGetter) {
        this.map(columnName, DataType.Char, propertyGetter);
    }

    protected void mapByte(String columnName, ToIntFunction<TEntity> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.writeByte(propertyGetter.applyAsInt(entity)));
    }

    protected void mapShort(String columnName, Function<TEntity, Number> propertyGetter) {
        this.map(columnName, DataType.Int2, propertyGetter);
    }

    protected void mapShort(String columnName, ToIntFunction<TEntity> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.writeShort(propertyGetter.applyAsInt(entity)));
    }

    protected void mapInteger(String columnName, Function<TEntity, Number> propertyGetter) {
        this.map(columnName, DataType.Int4, propertyGetter);
    }

    protected void mapInteger(String columnName, ToIntFunction<TEntity> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.writeInt(propertyGetter.applyAsInt(entity)));
    }

    protected void mapNumeric(String columnName, Function<TEntity, Number> propertyGetter) {
        this.map(columnName, DataType.Numeric, propertyGetter);
    }

    protected void mapLong(String columnName, Function<TEntity, Number> propertyGetter) {
        this.map(columnName, DataType.Int8, propertyGetter);
    }

    protected void mapLong(String columnName, ToLongFunction<TEntity> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.writeLong(propertyGetter.applyAsLong(entity)));
    }

    protected void mapFloat(String columnName, Function<TEntity, Number> propertyGetter) {
        this.map(columnName, DataType.SinglePrecision, propertyGetter);
    }

    protected void mapFloat(String columnName, ToFloatFunction<TEntity> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.writeFloat(propertyGetter.applyAsFloat(entity)));
    }

    protected void mapDouble(String columnName, Function<TEntity, Number> propertyGetter) {
        this.map(columnName, DataType.DoublePrecision, propertyGetter);
    }

    protected void mapDouble(String columnName, ToDoubleFunction<TEntity> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.writeDouble(propertyGetter.applyAsDouble(entity)));
    }

    protected void mapInet4Addr(String columnName, Function<TEntity, Inet4Address> propertyGetter) {
        this.map(columnName, DataType.Inet4, propertyGetter);
    }

    protected void mapInet6Addr(String columnName, Function<TEntity, Inet6Address> propertyGetter) {
        this.map(columnName, DataType.Inet6, propertyGetter);
    }

    protected void mapMacAddress(String columnName, Function<TEntity, MacAddress> propertyGetter) {
        this.map(columnName, DataType.MacAddress, propertyGetter);
    }

    protected void mapDate(String columnName, Function<TEntity, LocalDate> propertyGetter) {
        this.map(columnName, DataType.Date, propertyGetter);
    }

    protected void mapTimeStamp(String columnName, Function<TEntity, LocalDateTime> propertyGetter) {
        this.map(columnName, DataType.Timestamp, propertyGetter);
    }

    protected void mapTimeStampTz(String columnName, Function<TEntity, ZonedDateTime> propertyGetter) {
        this.map(columnName, DataType.TimestampTz, propertyGetter);
    }

    protected void mapText(String columnName, Function<TEntity, String> propertyGetter) {
        this.map(columnName, DataType.Text, propertyGetter);
    }

    protected void mapVarChar(String columnName, Function<TEntity, String> propertyGetter) {
        this.map(columnName, DataType.Text, propertyGetter);
    }

    protected void mapUUID(String columnName, Function<TEntity, UUID> propertyGetter) {
        this.map(columnName, DataType.Uuid, propertyGetter);
    }

    protected void mapJsonb(String columnName, Function<TEntity, String> propertyGetter) {
        this.map(columnName, DataType.Jsonb, propertyGetter);
    }

    protected void mapHstore(String columnName, Function<TEntity, Map<String, String>> propertyGetter) {
        this.map(columnName, DataType.Hstore, propertyGetter);
    }

    protected void mapPoint(String columnName, Function<TEntity, Point> propertyGetter) {
        this.map(columnName, DataType.Point, propertyGetter);
    }

    protected void mapBox(String columnName, Function<TEntity, Box> propertyGetter) {
        this.map(columnName, DataType.Box, propertyGetter);
    }

    protected void mapPath(String columnName, Function<TEntity, Path> propertyGetter) {
        this.map(columnName, DataType.Path, propertyGetter);
    }

    protected void mapPolygon(String columnName, Function<TEntity, Polygon> propertyGetter) {
        this.map(columnName, DataType.Polygon, propertyGetter);
    }

    protected void mapLine(String columnName, Function<TEntity, Line> propertyGetter) {
        this.map(columnName, DataType.Line, propertyGetter);
    }

    protected void mapLineSegment(String columnName, Function<TEntity, LineSegment> propertyGetter) {
        this.map(columnName, DataType.LineSegment, propertyGetter);
    }

    protected void mapCircle(String columnName, Function<TEntity, Circle> propertyGetter) {
        this.map(columnName, DataType.Circle, propertyGetter);
    }

    protected void mapBooleanArray(String columnName, Function<TEntity, Collection<Boolean>> propertyGetter) {
        this.mapCollection(columnName, DataType.Boolean, propertyGetter);
    }

    protected void mapByteArray(String columnName, Function<TEntity, byte[]> propertyGetter) {
        this.map(columnName, DataType.Bytea, propertyGetter);
    }

    protected <T extends Number> void mapShortArray(String columnName, Function<TEntity, Collection<T>> propertyGetter) {
        this.mapCollection(columnName, DataType.Int2, propertyGetter);
    }

    protected <T extends Number> void mapIntegerArray(String columnName, Function<TEntity, Collection<T>> propertyGetter) {
        this.mapCollection(columnName, DataType.Int4, propertyGetter);
    }

    protected <T extends Number> void mapLongArray(String columnName, Function<TEntity, Collection<T>> propertyGetter) {
        this.mapCollection(columnName, DataType.Int8, propertyGetter);
    }

    protected void mapTextArray(String columnName, Function<TEntity, Collection<String>> propertyGetter) {
        this.mapCollection(columnName, DataType.Text, propertyGetter);
    }

    protected void mapVarCharArray(String columnName, Function<TEntity, Collection<String>> propertyGetter) {
        this.mapCollection(columnName, DataType.VarChar, propertyGetter);
    }

    protected <T extends Number> void mapFloatArray(String columnName, Function<TEntity, Collection<T>> propertyGetter) {
        this.mapCollection(columnName, DataType.SinglePrecision, propertyGetter);
    }

    protected <T extends Number> void mapDoubleArray(String columnName, Function<TEntity, Collection<T>> propertyGetter) {
        this.mapCollection(columnName, DataType.DoublePrecision, propertyGetter);
    }

    protected <T extends Number> void mapNumericArray(String columnName, Function<TEntity, Collection<T>> propertyGetter) {
        this.mapCollection(columnName, DataType.Numeric, propertyGetter);
    }

    protected void mapUUIDArray(String columnName, Function<TEntity, Collection<UUID>> propertyGetter) {
        this.mapCollection(columnName, DataType.Uuid, propertyGetter);
    }

    protected void mapInet4Array(String columnName, Function<TEntity, Collection<Inet4Address>> propertyGetter) {
        this.mapCollection(columnName, DataType.Inet4, propertyGetter);
    }

    protected void mapInet6Array(String columnName, Function<TEntity, Collection<Inet6Address>> propertyGetter) {
        this.mapCollection(columnName, DataType.Inet6, propertyGetter);
    }

    protected <TElementType> void mapRange(String columnName, DataType dataType, Function<TEntity, Range<TElementType>> propertyGetter) {
        IValueHandler valueHandler = this.provider.resolve(dataType);
        this.map(columnName, new RangeValueHandler(valueHandler), propertyGetter);
    }

    protected void mapTsRange(String columnName, Function<TEntity, Range<LocalDateTime>> propertyGetter) {
        this.map(columnName, DataType.TsRange, propertyGetter);
    }

    protected void mapTsTzRange(String columnName, Function<TEntity, Range<ZonedDateTime>> propertyGetter) {
        this.map(columnName, DataType.TsTzRange, propertyGetter);
    }

    protected void mapInt4Range(String columnName, Function<TEntity, Range<Integer>> propertyGetter) {
        this.map(columnName, DataType.Int4Range, propertyGetter);
    }

    protected void mapInt8Range(String columnName, Function<TEntity, Range<Long>> propertyGetter) {
        this.map(columnName, DataType.Int8Range, propertyGetter);
    }

    protected void mapNumRange(String columnName, Function<TEntity, Range<Number>> propertyGetter) {
        this.map(columnName, DataType.NumRange, propertyGetter);
    }

    protected void mapDateRange(String columnName, Function<TEntity, Range<LocalDate>> propertyGetter) {
        this.map(columnName, DataType.DateRange, propertyGetter);
    }

    private void addColumn(String columnName, BiConsumer<PgBinaryWriter, TEntity> action) {
        this.columns.add(new ColumnDefinition<TEntity>(columnName, action));
    }

    public List<ColumnDefinition<TEntity>> getColumns() {
        return this.columns;
    }

    public String getCopyCommand() {
        String commaSeparatedColumns = this.columns.stream().map(x -> x.getColumnName()).map(x -> this.usePostgresQuoting ? PostgreSqlUtils.quoteIdentifier(x) : x).collect(Collectors.joining(", "));
        return String.format("COPY %1$s(%2$s) FROM STDIN BINARY", this.table.GetFullyQualifiedTableName(this.usePostgresQuoting), commaSeparatedColumns);
    }
}

