/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.util;

import de.bytefish.pgbulkinsert.exceptions.PgConnectionException;
import de.bytefish.pgbulkinsert.util.OutParameter;
import de.bytefish.pgbulkinsert.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.postgresql.PGConnection;

public final class PostgreSqlUtils {
    public static final char QuoteChar = '\"';

    private PostgreSqlUtils() {
    }

    public static PGConnection getPGConnection(Connection connection) throws SQLException {
        OutParameter<PGConnection> result = new OutParameter<PGConnection>();
        if (!PostgreSqlUtils.tryGetPGConnection(connection, result)) {
            throw new PgConnectionException("Could not obtain a PGConnection");
        }
        return result.get();
    }

    public static boolean tryGetPGConnection(Connection connection, OutParameter<PGConnection> result) throws SQLException {
        if (PostgreSqlUtils.tryCastConnection(connection, result)) {
            return true;
        }
        return PostgreSqlUtils.tryUnwrapConnection(connection, result);
    }

    private static boolean tryCastConnection(Connection connection, OutParameter<PGConnection> result) {
        if (connection instanceof PGConnection) {
            result.set((PGConnection)connection);
            return true;
        }
        return false;
    }

    private static boolean tryUnwrapConnection(Connection connection, OutParameter<PGConnection> result) {
        try {
            if (connection.isWrapperFor(PGConnection.class)) {
                result.set(connection.unwrap(PGConnection.class));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String quoteIdentifier(String identifier) {
        return PostgreSqlUtils.requiresQuoting(identifier) ? '\"' + identifier + '\"' : identifier;
    }

    public static String getFullyQualifiedTableName(String schemaName, String tableName, boolean usePostgresQuoting) {
        if (usePostgresQuoting) {
            return StringUtils.isNullOrWhiteSpace(schemaName) ? PostgreSqlUtils.quoteIdentifier(tableName) : String.format("%s.%s", PostgreSqlUtils.quoteIdentifier(schemaName), PostgreSqlUtils.quoteIdentifier(tableName));
        }
        if (StringUtils.isNullOrWhiteSpace(schemaName)) {
            return tableName;
        }
        return String.format("%1$s.%2$s", schemaName, tableName);
    }

    private static boolean requiresQuoting(String identifier) {
        char first = identifier.charAt(0);
        char last = identifier.charAt(identifier.length() - 1);
        if (first == '\"' && last == '\"') {
            return false;
        }
        if (!Character.isLowerCase(first) && first != '_') {
            return true;
        }
        block3: for (int i = 1; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (Character.isLowerCase(c)) continue;
            switch (c) {
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '_': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }
}

