/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.streams;

import de.bytefish.pgbulkinsert.streams.BatchSpliterator;
import de.bytefish.pgbulkinsert.streams.HoldingConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Spliterator;
import java.util.function.Consumer;

public class PartitioningSpliterator<T>
extends BatchSpliterator<Collection<T>> {
    private final Spliterator<T> spliterator;
    private final int partitionSize;

    public PartitioningSpliterator(Spliterator<T> spliterator, int partitionSize, int batchSize) {
        super(batchSize, 1297);
        assert (partitionSize > 0);
        this.spliterator = spliterator;
        this.partitionSize = partitionSize;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Collection<T>> consumer) {
        HoldingConsumer holder = new HoldingConsumer();
        if (!this.spliterator.tryAdvance(holder)) {
            return false;
        }
        ArrayList<Object> partition = new ArrayList<Object>();
        int j = 0;
        do {
            partition.add(holder.getValue());
        } while (++j < this.partitionSize && this.spliterator.tryAdvance(holder));
        consumer.accept(partition);
        return true;
    }
}

