/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.streams;

import de.bytefish.pgbulkinsert.streams.HoldingConsumer;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.Spliterators;

public abstract class BatchSpliterator<T>
implements Spliterator<T> {
    private final int batchSize;
    private final int characteristics;

    public BatchSpliterator(int batchSize, int characteristics) {
        this.batchSize = batchSize;
        this.characteristics = characteristics | 0x4000;
    }

    @Override
    public Spliterator<T> trySplit() {
        HoldingConsumer consumer = new HoldingConsumer();
        if (!this.tryAdvance(consumer)) {
            return null;
        }
        Object[] batch = new Object[this.batchSize];
        int j = 0;
        do {
            batch[j] = consumer.getValue();
        } while (++j < this.batchSize && this.tryAdvance(consumer));
        return Spliterators.spliterator(batch, 0, j, this.characteristics() | 0x40);
    }

    @Override
    public Comparator<? super T> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

