/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.util.BigDecimalUtils;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class BigDecimalValueHandler<T extends Number>
extends BaseValueHandler<T> {
    private static final int DECIMAL_DIGITS = 4;
    protected static final BigInteger TEN = new BigInteger("10");
    protected static final BigInteger TEN_THOUSAND = new BigInteger("10000");

    @Override
    protected void internalHandle(DataOutputStream buffer, T value) throws Exception {
        Object tmpValue = value;
        if (!(value instanceof BigDecimal)) {
            tmpValue = BigDecimalUtils.toBigDecimal(((Number)value).doubleValue());
        }
        BigInteger unscaledValue = ((BigDecimal)tmpValue).unscaledValue();
        int sign = ((BigDecimal)tmpValue).signum();
        if (sign == -1) {
            unscaledValue = unscaledValue.negate();
        }
        int fractionDigits = ((BigDecimal)tmpValue).scale();
        int fractionGroups = (fractionDigits + 3) / 4;
        ArrayList<Integer> digits = new ArrayList<Integer>();
        int scaleRemainder = fractionDigits % 4;
        BigInteger[] result = unscaledValue.divideAndRemainder(TEN.pow(scaleRemainder));
        int digit = result[1].intValue() * (int)Math.pow(10.0, 4 - scaleRemainder);
        digits.add(new Integer(digit));
        unscaledValue = result[0];
        while (!unscaledValue.equals(BigInteger.ZERO)) {
            result = unscaledValue.divideAndRemainder(TEN_THOUSAND);
            digits.add(new Integer(result[1].intValue()));
            unscaledValue = result[0];
        }
        buffer.writeInt(8 + 2 * digits.size());
        buffer.writeShort(digits.size());
        buffer.writeShort(digits.size() - fractionGroups - 1);
        buffer.writeShort(sign == 1 ? 0 : 16384);
        buffer.writeShort(fractionDigits);
        for (int pos = digits.size() - 1; pos >= 0; --pos) {
            int valueToWrite = (Integer)digits.get(pos);
            buffer.writeShort(valueToWrite);
        }
    }
}

