/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.processor.handler;

import de.bytefish.pgbulkinsert.IPgBulkInsert;
import de.bytefish.pgbulkinsert.functional.Func1;
import de.bytefish.pgbulkinsert.pgsql.processor.handler.IBulkWriteHandler;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.util.List;
import org.postgresql.PGConnection;

public class BulkWriteHandler<TEntity>
implements IBulkWriteHandler<TEntity> {
    private final IPgBulkInsert<TEntity> client;
    private final Func1<Connection> connectionFactory;

    public BulkWriteHandler(IPgBulkInsert<TEntity> client, Func1<Connection> connectionFactory) {
        this.client = client;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void write(List<TEntity> entities) throws Exception {
        try (Connection connection = this.connectionFactory.invoke();){
            PGConnection pgConnection = PostgreSqlUtils.getPGConnection(connection);
            this.client.saveAll(pgConnection, entities.stream());
        }
    }
}

